/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.management.ManageableComponent;
import flex.messaging.AbstractFlexSessionProvider;
import flex.messaging.FlexSession;
import flex.messaging.MessageBroker;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class FlexSessionManager
extends ManageableComponent {
    public static final String TYPE = "FlexSessionManager";
    private static final long MILLIS_IN_HOUR = 3600000L;
    private final Object lock = new Object();
    private int flexSessionCount;
    private final ConcurrentHashMap<Class<? extends FlexSession>, AbstractFlexSessionProvider> providers = new ConcurrentHashMap();
    private int maxSessionCountInCurrentHour;
    private long currentHourStartTimestamp = System.currentTimeMillis();
    private final MessageBroker broker;

    public FlexSessionManager(MessageBroker broker) {
        this(false, broker);
    }

    public FlexSessionManager(boolean enableManagement, MessageBroker broker) {
        super(enableManagement);
        super.setId(TYPE);
        this.broker = broker;
        this.setParent(broker);
    }

    @Override
    protected String getLogCategory() {
        return "Endpoint.FlexSession";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlexSessionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.flexSessionCount;
        }
    }

    public AbstractFlexSessionProvider getFlexSessionProvider(Class<? extends FlexSession> sessionClass) {
        return this.providers.get(sessionClass);
    }

    public AbstractFlexSessionProvider registerFlexSessionProvider(Class<? extends FlexSession> sessionClass, AbstractFlexSessionProvider provider) {
        provider.setFlexSessionManager(this);
        AbstractFlexSessionProvider previousProvider = this.providers.putIfAbsent(sessionClass, provider);
        if (previousProvider != null) {
            previousProvider.stop();
            previousProvider.setFlexSessionManager(null);
        }
        if (this.isStarted()) {
            provider.start();
        }
        return previousProvider;
    }

    public void unregisterFlexSessionProvider(Class<? extends FlexSession> sessionClass) {
        AbstractFlexSessionProvider provider = this.providers.remove(sessionClass);
        if (provider != null) {
            provider.stop();
            provider.setFlexSessionManager(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFlexSession(FlexSession session) {
        Object object = this.lock;
        synchronized (object) {
            ++this.flexSessionCount;
            this.resetMaxFlexSessionsInCurrentHour(this.flexSessionCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFlexSession(FlexSession session) {
        Object object = this.lock;
        synchronized (object) {
            --this.flexSessionCount;
            this.resetMaxFlexSessionsInCurrentHour(this.flexSessionCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxFlexSessionsInCurrentHour() {
        Object object = this.lock;
        synchronized (object) {
            this.resetMaxFlexSessionsInCurrentHour(this.flexSessionCount);
            return this.maxSessionCountInCurrentHour;
        }
    }

    private void resetMaxFlexSessionsInCurrentHour(int currentCount) {
        long offset = (System.currentTimeMillis() - this.currentHourStartTimestamp) / 3600000L;
        if (offset > 0L) {
            this.currentHourStartTimestamp += 3600000L * offset;
            this.maxSessionCountInCurrentHour = currentCount;
        } else if (this.maxSessionCountInCurrentHour < currentCount) {
            this.maxSessionCountInCurrentHour = currentCount;
        }
    }

    public MessageBroker getMessageBroker() {
        return this.broker;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        for (AbstractFlexSessionProvider provider : this.providers.values()) {
            if (provider.isStarted()) continue;
            provider.start();
        }
        super.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        Enumeration<Class<? extends FlexSession>> sessionClasses = this.providers.keys();
        while (sessionClasses.hasMoreElements()) {
            Class<? extends FlexSession> sessionClass = sessionClasses.nextElement();
            this.unregisterFlexSessionProvider(sessionClass);
        }
        this.providers.clear();
    }
}

