/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.HTTPEndpointControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BasePollingHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.endpoints.amf.BatchProcessFilter;
import flex.messaging.endpoints.amf.MessageBrokerFilter;
import flex.messaging.endpoints.amf.SerializationFilter;
import flex.messaging.endpoints.amf.SessionFilter;
import flex.messaging.messages.Message;
import flex.messaging.security.SecurityException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPEndpoint
extends BasePollingHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.HTTP";
    private static final int IMPROPER_CONTENT_TYPE = 10068;

    public HTTPEndpoint() {
        this(false);
    }

    public HTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    public Message convertToSmallMessage(Message message) {
        return message;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) {
        boolean xmlContentType;
        String contentType = req.getContentType();
        boolean bl = xmlContentType = contentType == null || contentType.equals("application/xml");
        if (!xmlContentType) {
            SecurityException se = new SecurityException();
            se.setMessage(10068, new Object[]{this.id});
            throw se;
        }
        super.service(req, res);
    }

    @Override
    protected AMFFilter createFilterChain() {
        SerializationFilter serializationFilter = new SerializationFilter(this.getLogCategory());
        BatchProcessFilter batchFilter = new BatchProcessFilter();
        SessionFilter sessionFilter = this.sessionRewritingEnabled ? new SessionFilter() : null;
        MessageBrokerFilter messageBrokerFilter = new MessageBrokerFilter(this);
        serializationFilter.setNext(batchFilter);
        if (sessionFilter != null) {
            batchFilter.setNext(sessionFilter);
            sessionFilter.setNext(messageBrokerFilter);
        } else {
            batchFilter.setNext(messageBrokerFilter);
        }
        return serializationFilter;
    }

    @Override
    protected String getResponseContentType() {
        return "application/xml";
    }

    @Override
    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    @Override
    protected String getDeserializerClassName() {
        return "flex.messaging.io.amfx.AmfxMessageDeserializer";
    }

    @Override
    protected String getSerializerClassName() {
        return "flex.messaging.io.amfx.AmfxMessageSerializer";
    }

    @Override
    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new HTTPEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }
}

