/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.parsing.as;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.internal.parsing.as.ASDocToken;
import org.apache.flex.compiler.internal.parsing.as.RawASDocTokenizer;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.InternalCompilerProblem;

public class ASDocTokenizer {
    private boolean fromMXML = false;
    private List<ICompilerProblem> problems;
    private RawASDocTokenizer tokenizer;

    public ASDocTokenizer(boolean fromMXML) {
        this.fromMXML = fromMXML;
        this.problems = new ArrayList<ICompilerProblem>(2);
    }

    public void setReader(Reader input) {
        this.tokenizer = new RawASDocTokenizer(input);
        this.tokenizer.setFromMXML(this.fromMXML);
    }

    public ASDocToken next() {
        ASDocToken token = null;
        boolean needToken = true;
        while (needToken) {
            try {
                token = this.tokenizer.nextToken();
                needToken = false;
            }
            catch (Exception e) {
                needToken = true;
                this.problems.add(new InternalCompilerProblem(e));
            }
        }
        if (token == null) {
            return null;
        }
        switch (token.getType()) {
            case 9: 
            case 10: {
                return token;
            }
        }
        return null;
    }

    public void close() throws IOException {
        if (this.tokenizer != null) {
            this.tokenizer.reset();
            this.tokenizer.yyclose();
        }
    }
}

