/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.embedding.transcoders.MovieTranscoder;
import org.apache.flex.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.targets.FlexFontInfo;
import org.apache.flex.compiler.internal.units.EmbedCompilationUnit;
import org.apache.flex.compiler.internal.units.ResourceBundleCompilationUnit;
import org.apache.flex.compiler.problems.DependencyNotCompatibleProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.IFileScopeRequestResult;
import org.apache.flex.swc.ISWC;

abstract class FlexFrame1Info {
    protected final FlexProject flexProject;
    private final ClassDefinition resourceBundleDefinition;
    final TreeSet<String> compiledResourceBundleNames;
    final TreeMap<String, FlexFontInfo> embeddedFonts;
    final ArrayList<ICompilerProblem> problems;

    protected FlexFrame1Info(FlexProject flexProject) {
        this.flexProject = flexProject;
        IResolvedQualifiersReference resourceBundleRef = ReferenceFactory.packageQualifiedReference(flexProject.getWorkspace(), flexProject.getResourceBundleClass());
        this.resourceBundleDefinition = (ClassDefinition)resourceBundleRef.resolve(flexProject);
        this.compiledResourceBundleNames = new TreeSet();
        this.embeddedFonts = new TreeMap();
        this.problems = new ArrayList();
    }

    protected final void collectFromCompilationUnits(Iterable<ICompilationUnit> builtCompilationUnits) throws InterruptedException {
        for (ICompilationUnit cu : builtCompilationUnits) {
            this.collectFromCompilationUnit(cu);
        }
    }

    protected void collectFromCompilationUnit(ICompilationUnit cu) throws InterruptedException {
        if (this.resourceBundleDefinition != null) {
            this.collectCompiledResourceBundleNames(cu);
        }
        this.collectEmbeddedFonts(cu);
        this.checkSWCVersioningFilter(this.problems, cu);
    }

    private final void collectEmbeddedFonts(ICompilationUnit compilationUnit) {
        if (!(compilationUnit instanceof EmbedCompilationUnit)) {
            return;
        }
        TranscoderBase transcoder = ((EmbedCompilationUnit)compilationUnit).getEmbedData().getTranscoder();
        if (!(transcoder instanceof MovieTranscoder)) {
            return;
        }
        MovieTranscoder movieTranscoder = (MovieTranscoder)transcoder;
        FlexFontInfo flexFontInfo = movieTranscoder.getFlexFontInfo();
        if (flexFontInfo != null) {
            this.embeddedFonts.put(movieTranscoder.getSymbol(), flexFontInfo);
        }
    }

    private void collectCompiledResourceBundleNames(ICompilationUnit compilationUnit) throws InterruptedException {
        if (compilationUnit instanceof ResourceBundleCompilationUnit) {
            this.compiledResourceBundleNames.add(((ResourceBundleCompilationUnit)compilationUnit).getBundleNameInColonSyntax());
        } else {
            IFileScopeRequestResult result = compilationUnit.getFileScopeRequest().get();
            for (IDefinition def : result.getExternallyVisibleDefinitions()) {
                ClassDefinition classDef;
                if (!(def instanceof ClassDefinition) || this.resourceBundleDefinition.equals(classDef = (ClassDefinition)def) || !classDef.isInstanceOf(this.resourceBundleDefinition, (ICompilerProject)this.flexProject)) continue;
                this.compiledResourceBundleNames.add(def.getQualifiedName());
            }
        }
    }

    private void checkSWCVersioningFilter(ArrayList<ICompilerProblem> problems, ICompilationUnit cu) throws InterruptedException {
        Integer compatibilityVersion = this.flexProject.getCompatibilityVersion();
        if (compatibilityVersion == null) {
            return;
        }
        if (cu.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT) {
            return;
        }
        Set<ICompilationUnit> dependencies = this.flexProject.getDependencies(cu);
        for (ICompilationUnit dependency : dependencies) {
            if (dependency.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT) continue;
            ISWC swc = this.flexProject.getWorkspace().getSWCManager().get(new File(dependency.getAbsoluteFilename()));
            int flexMinSupportedVersion = swc.getVersion().getFlexMinSupportedVersionInt();
            if (compatibilityVersion >= flexMinSupportedVersion) continue;
            problems.add(new DependencyNotCompatibleProblem(dependency.getQualifiedNames().get(0), dependency.getAbsoluteFilename(), swc.getVersion().getFlexMinSupportedVersion(), this.flexProject.getCompatibilityVersionString()));
        }
    }

    Set<String> getMixins() {
        return Collections.emptySet();
    }
}

