/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.flexjs;

import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.asdoc.flexjs.ASDocComment;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSessionModel;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogDocEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.IVariableNode;

public class JSFlexJSDocEmitter
extends JSGoogDocEmitter {
    private List<String> classIgnoreList;
    private List<String> ignoreList;
    private List<String> coercionList;
    public boolean emitStringConversions = true;
    private boolean usedNames = false;

    public JSFlexJSDocEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    public List<String> getClassIgnoreList() {
        return this.classIgnoreList;
    }

    public void setClassIgnoreList(List<String> value) {
        this.classIgnoreList = value;
    }

    @Override
    protected String convertASTypeToJS(String name, String pname) {
        if (this.ignoreList != null && this.ignoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.coercionList != null && !this.coercionList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.classIgnoreList != null && this.classIgnoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (name.matches("Vector\\.<.*>")) {
            return "Array";
        }
        name = super.convertASTypeToJS(name, pname);
        return this.formatQualifiedName(name);
    }

    @Override
    protected String formatQualifiedName(String name) {
        return ((JSFlexJSEmitter)this.emitter).formatQualifiedName(name, !this.usedNames);
    }

    @Override
    public void emitMethodDoc(IFunctionNode node, ICompilerProject project) {
        FlexJSProject fjp = (FlexJSProject)project;
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        this.coercionList = null;
        this.ignoreList = null;
        this.emitStringConversions = true;
        IClassDefinition classDefinition = this.resolveClassDefinition(node);
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (node instanceof IFunctionNode) {
            boolean hasDoc = false;
            Boolean override = false;
            if (node.isConstructor()) {
                String qname;
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
                this.emitJSDocLine(JSEmitterTokens.CONSTRUCTOR);
                IClassDefinition parent = (IClassDefinition)node.getDefinition().getParent();
                IClassDefinition superClass = parent.resolveBaseClass(project);
                String string = qname = superClass != null ? project.getActualPackageName(superClass.getQualifiedName()) : null;
                if ((superClass == null || qname.equals("Object")) && ((JSFlexJSEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.EXTENDS) {
                    superClass = (IClassDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_CLASS_QNAME);
                    if (superClass == null) {
                        System.out.println(BindableEmitter.DISPATCHER_CLASS_QNAME + " not resolved for implicit super class in " + classDefinition.getQualifiedName());
                    } else {
                        qname = BindableEmitter.DISPATCHER_CLASS_QNAME;
                    }
                }
                this.usedNames = true;
                if (superClass != null && !qname.equals("Object")) {
                    this.emitExtends(superClass, superClass.getPackageName());
                }
                IReference[] references = classDefinition.getImplementedInterfaceReferences();
                Boolean sawIEventDispatcher = false;
                Boolean needsIEventDispatcher = ((JSFlexJSEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS;
                for (IReference iReference : references) {
                    ITypeDefinition type = (ITypeDefinition)iReference.resolve(project, (ASScope)classDefinition.getContainingScope(), DependencyType.INHERITANCE, true);
                    if (type == null) {
                        System.out.println(iReference.getDisplayString() + " not resolved in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                    if (type.getQualifiedName() != BindableEmitter.DISPATCHER_INTERFACE_QNAME) continue;
                    sawIEventDispatcher = true;
                }
                if (needsIEventDispatcher.booleanValue() && !sawIEventDispatcher.booleanValue()) {
                    ITypeDefinition type = (ITypeDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_INTERFACE_QNAME);
                    if (type == null) {
                        System.out.println(BindableEmitter.DISPATCHER_INTERFACE_QNAME + " not resolved for implicit implementation in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                }
                this.usedNames = false;
            } else {
                override = node.hasModifier(ASModifier.OVERRIDE);
                String ns = node.getNamespace();
                if (ns != null) {
                    if (asDoc != null && keepASDoc) {
                        String noStringToken;
                        String ignoreToken;
                        String keepToken;
                        IParameterNode[] docText = asDoc.commentNoEnd();
                        if (docText.contains(keepToken = JSFlexJSEmitterTokens.EMIT_COERCION.getToken())) {
                            this.loadKeepers((String)docText);
                        }
                        if (docText.contains(ignoreToken = JSFlexJSEmitterTokens.IGNORE_COERCION.getToken())) {
                            this.loadIgnores((String)docText);
                        }
                        if (docText.contains(noStringToken = JSFlexJSEmitterTokens.IGNORE_STRING_COERCION.getToken())) {
                            this.emitStringConversions = false;
                        }
                        this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                    } else {
                        this.begin();
                    }
                    this.emitMethodAccess(node);
                    hasDoc = true;
                }
            }
            if (!override.booleanValue()) {
                IParameterNode[] parameters;
                for (IParameterNode pnode : parameters = node.getParameterNodes()) {
                    IExpressionNode enode;
                    ITypeDefinition tdef;
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    if ((tdef = (enode = pnode.getNameExpressionNode()).resolveType(project)) == null) continue;
                    this.emitParam(pnode, project.getActualPackageName(tdef.getPackageName()));
                }
            }
            if (!node.isConstructor()) {
                String returnType;
                if (!override.booleanValue() && (returnType = node.getReturnType()) != "" && returnType != ASEmitterTokens.VOID.getToken()) {
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    ITypeDefinition tdef = node.getDefinition().resolveReturnType(project);
                    String packageName = "";
                    packageName = tdef != null ? tdef.getPackageName() : "";
                    this.emitReturn(node, project.getActualPackageName(packageName));
                }
                if (override.booleanValue()) {
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    this.emitOverride(node);
                }
            }
            if (hasDoc) {
                this.end();
            }
        }
    }

    private void loadIgnores(String doc) {
        this.ignoreList = new ArrayList<String>();
        String ignoreToken = JSFlexJSEmitterTokens.IGNORE_COERCION.getToken();
        int index = doc.indexOf(ignoreToken);
        while (index != -1) {
            String ignore = doc.substring(index + ignoreToken.length());
            int endIndex = ignore.indexOf("\n");
            ignore = ignore.substring(0, endIndex);
            ignore = ignore.trim();
            this.ignoreList.add(ignore);
            index = doc.indexOf(ignoreToken, index + endIndex);
        }
    }

    private void loadKeepers(String doc) {
        this.coercionList = new ArrayList<String>();
        String keepToken = JSFlexJSEmitterTokens.EMIT_COERCION.getToken();
        int index = doc.indexOf(keepToken);
        while (index != -1) {
            String keeper = doc.substring(index + keepToken.length());
            int endIndex = keeper.indexOf("\n");
            keeper = keeper.substring(0, endIndex);
            keeper = keeper.trim();
            this.coercionList.add(keeper);
            index = doc.indexOf(keepToken, index + endIndex);
        }
    }

    private String changeAnnotations(String doc) {
        String pass1 = doc.replaceAll("@param", "@asparam");
        String pass2 = pass1.replaceAll("@return", "@asreturn");
        String pass3 = pass2.replaceAll("@private", "@asprivate");
        return pass3;
    }

    @Override
    public void emitInterfaceMemberDoc(IDefinitionNode node, ICompilerProject project) {
        IParameterNode[] parameters;
        FlexJSProject fjp = (FlexJSProject)project;
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        boolean hasDoc = false;
        ASDocComment asDoc = (ASDocComment)((IFunctionNode)node).getASDocComment();
        String returnType = ((IFunctionNode)node).getReturnType();
        if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
            if (asDoc != null && keepASDoc) {
                this.write(this.changeAnnotations(asDoc.commentNoEnd()));
            } else {
                this.begin();
            }
            hasDoc = true;
            ITypeDefinition tdef = ((IFunctionDefinition)node.getDefinition()).resolveReturnType(project);
            this.emitReturn((IFunctionNode)node, tdef.getPackageName());
        }
        for (IParameterNode pnode : parameters = ((IFunctionNode)node).getParameterNodes()) {
            if (!hasDoc) {
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
            }
            IExpressionNode enode = pnode.getNameExpressionNode();
            this.emitParam(pnode, enode.resolveType(project).getPackageName());
        }
        if (hasDoc) {
            this.end();
        }
    }

    @Override
    public void emitMethodAccess(IFunctionNode node) {
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        } else if (ns != null && ns == "public") {
            this.emitPublic((IASNode)node);
        }
    }

    @Override
    public void emitFieldDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        this.begin();
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        } else {
            this.emitPublic((IASNode)node);
        }
        if (node.isConst()) {
            this.emitConst(node);
        }
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        this.emitType((IASNode)node, project.getActualPackageName(packageName));
        this.end();
    }
}

