/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.memory;

import java.util.LinkedList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.runtime.util.MemorySegmentPool;

public class HeapMemorySegmentPool
implements MemorySegmentPool {
    private final LinkedList<MemorySegment> segments = new LinkedList();
    private final int maxPages;
    private final int pageSize;
    private int numPage;

    public HeapMemorySegmentPool(long maxMemory, int pageSize) {
        this.maxPages = (int)(maxMemory / (long)pageSize);
        this.pageSize = pageSize;
        this.numPage = 0;
    }

    public MemorySegment nextSegment() {
        if (this.segments.size() > 0) {
            return this.segments.poll();
        }
        if (this.numPage < this.maxPages) {
            ++this.numPage;
            return MemorySegmentFactory.allocateUnpooledSegment((int)this.pageSize);
        }
        return null;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public void returnAll(List<MemorySegment> memory) {
        this.segments.addAll(memory);
    }

    public int freePages() {
        return this.segments.size() + this.maxPages - this.numPage;
    }
}

