/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.writer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.writer.FileWriter;
import org.apache.flink.table.store.file.writer.Metric;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.store.format.FieldStatsCollector;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFileWriter<T>
implements FileWriter<T, Metric> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricFileWriter.class);
    private final BulkWriter<RowData> writer;
    private final Function<T, RowData> converter;
    private final FSDataOutputStream out;
    private final Path path;
    @Nullable
    private final FileStatsExtractor fileStatsExtractor;
    private FieldStatsCollector fieldStatsCollector = null;
    private long recordCount;
    private long length;
    private boolean closed = false;

    private MetricFileWriter(BulkWriter<RowData> writer, Function<T, RowData> converter, FSDataOutputStream out, Path path, RowType writeSchema, @Nullable FileStatsExtractor fileStatsExtractor) {
        this.writer = writer;
        this.converter = converter;
        this.out = out;
        this.path = path;
        this.fileStatsExtractor = fileStatsExtractor;
        if (this.fileStatsExtractor == null) {
            this.fieldStatsCollector = new FieldStatsCollector(writeSchema);
        }
        this.recordCount = 0L;
        this.length = 0L;
    }

    @Override
    public void write(T record) throws IOException {
        RowData rowData = this.converter.apply(record);
        this.writer.addElement((Object)rowData);
        if (this.fieldStatsCollector != null) {
            this.fieldStatsCollector.collect(rowData);
        }
        ++this.recordCount;
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    @Override
    public long length() {
        try {
            return this.out.getPos();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        FileUtils.deleteOrWarn(this.path);
    }

    @Override
    public Metric result() throws IOException {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot access metric unless the writer is closed.");
        FieldStats[] stats = this.fileStatsExtractor != null ? this.fileStatsExtractor.extract(this.path) : this.fieldStatsCollector.extract();
        return new Metric(stats, this.recordCount, this.length);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.finish();
            }
            if (this.out != null) {
                this.out.flush();
                this.length = this.out.getPos();
                this.out.close();
            }
            this.closed = true;
        }
    }

    public static <T> FileWriter.Factory<T, Metric> createFactory(BulkWriter.Factory<RowData> factory, Function<T, RowData> converter, RowType writeSchema, @Nullable FileStatsExtractor fileStatsExtractor) {
        return path -> {
            FileSystem fs = path.getFileSystem();
            FSDataOutputStream out = fs.create(path, FileSystem.WriteMode.NO_OVERWRITE);
            try {
                return new MetricFileWriter((BulkWriter<RowData>)factory.create(out), converter, out, path, writeSchema, fileStatsExtractor);
            }
            catch (Throwable e) {
                LOG.warn("Failed to open the bulk writer, closing the output stream and throw the error.", e);
                IOUtils.closeQuietly((AutoCloseable)out);
                throw e;
            }
        };
    }
}

