/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.source.reader.deserializer;

import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.store.shaded.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.table.store.shaded.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.util.Collector;

class KafkaDeserializationSchemaWrapper<T>
implements KafkaRecordDeserializationSchema<T> {
    private static final long serialVersionUID = 1L;
    private final KafkaDeserializationSchema<T> kafkaDeserializationSchema;

    KafkaDeserializationSchemaWrapper(KafkaDeserializationSchema<T> kafkaDeserializationSchema) {
        this.kafkaDeserializationSchema = kafkaDeserializationSchema;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.kafkaDeserializationSchema.open(context);
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> message, Collector<T> out) throws IOException {
        try {
            this.kafkaDeserializationSchema.deserialize(message, out);
        }
        catch (Exception exception) {
            throw new IOException(String.format("Failed to deserialize consumer record %s.", message), exception);
        }
    }

    public TypeInformation<T> getProducedType() {
        return this.kafkaDeserializationSchema.getProducedType();
    }
}

