/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.utils;

import java.time.DateTimeException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.store.utils.DateTimeUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;

public class TypeUtils {
    private static final List<BinaryStringData> TRUE_STRINGS = Stream.of("t", "true", "y", "yes", "1").map(BinaryStringData::fromString).peek(BinaryStringData::ensureMaterialized).collect(Collectors.toList());
    private static final List<BinaryStringData> FALSE_STRINGS = Stream.of("f", "false", "n", "no", "0").map(BinaryStringData::fromString).peek(BinaryStringData::ensureMaterialized).collect(Collectors.toList());

    public static RowType project(RowType inputType, int[] mapping) {
        List fields = inputType.getFields();
        return new RowType(Arrays.stream(mapping).mapToObj(fields::get).collect(Collectors.toList()));
    }

    public static Object castFromString(String s, LogicalType type) {
        BinaryStringData str = BinaryStringData.fromString((String)s);
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return str;
            }
            case BOOLEAN: {
                return TypeUtils.toBoolean(str);
            }
            case BINARY: 
            case VARBINARY: {
                return s.getBytes();
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return BinaryStringDataUtil.toDecimal((BinaryStringData)str, (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case TINYINT: {
                return BinaryStringDataUtil.toByte((BinaryStringData)str);
            }
            case SMALLINT: {
                return BinaryStringDataUtil.toShort((BinaryStringData)str);
            }
            case INTEGER: {
                return BinaryStringDataUtil.toInt((BinaryStringData)str);
            }
            case BIGINT: {
                return BinaryStringDataUtil.toLong((BinaryStringData)str);
            }
            case FLOAT: {
                return Float.valueOf(BinaryStringDataUtil.toFloat((BinaryStringData)str));
            }
            case DOUBLE: {
                return BinaryStringDataUtil.toDouble((BinaryStringData)str);
            }
            case DATE: {
                return TypeUtils.toDate(str);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return TypeUtils.toTime(str);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                return TypeUtils.toTimestamp(str, timestampType.getPrecision());
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + type);
    }

    public static int timestampPrecision(LogicalType type) {
        if (type instanceof TimestampType) {
            return ((TimestampType)type).getPrecision();
        }
        if (type instanceof LocalZonedTimestampType) {
            return ((LocalZonedTimestampType)type).getPrecision();
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static boolean toBoolean(BinaryStringData str) throws TableException {
        BinaryStringData lowerCase = str.toLowerCase();
        if (TRUE_STRINGS.contains(lowerCase)) {
            return true;
        }
        if (FALSE_STRINGS.contains(lowerCase)) {
            return false;
        }
        throw new TableException("Cannot parse '" + str + "' as BOOLEAN.");
    }

    public static int toDate(BinaryStringData input) throws DateTimeException {
        Integer date = DateTimeUtils.parseDate(input.toString());
        if (date == null) {
            throw new DateTimeException("For input string: '" + input + "'.");
        }
        return date;
    }

    public static int toTime(BinaryStringData input) throws DateTimeException {
        Integer date = DateTimeUtils.parseTime(input.toString());
        if (date == null) {
            throw new DateTimeException("For input string: '" + input + "'.");
        }
        return date;
    }

    public static TimestampData toTimestamp(BinaryStringData input, int precision) throws DateTimeException {
        return DateTimeUtils.parseTimestampData(input.toString(), precision);
    }
}

