/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.table.source.Split;

public class FileStoreSourceSplitSerializer
implements SimpleVersionedSerializer<FileStoreSourceSplit> {
    public int getVersion() {
        return 1;
    }

    public byte[] serialize(FileStoreSourceSplit split) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        view.writeUTF(split.splitId());
        split.split().serialize((DataOutputView)view);
        view.writeLong(split.recordsToSkip());
        return out.toByteArray();
    }

    public FileStoreSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return new FileStoreSourceSplit(view.readUTF(), Split.deserialize((DataInputView)view), view.readLong());
    }
}

