/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.store.connector.sink.Committable;
import org.apache.flink.table.store.connector.sink.StoreSinkWriteImpl;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullChangelogStoreSinkWrite
extends StoreSinkWriteImpl {
    private static final Logger LOG = LoggerFactory.getLogger(FullChangelogStoreSinkWrite.class);
    private final long fullCompactionThresholdMs;
    private final Set<Tuple2<BinaryRowData, Integer>> currentWrittenBuckets;
    private final NavigableMap<Long, Set<Tuple2<BinaryRowData, Integer>>> writtenBuckets;
    private final ListState<Tuple3<Long, BinaryRowData, Integer>> writtenBucketState;
    private Long currentFirstWriteMs;
    private final NavigableMap<Long, Long> firstWriteMs;
    private final ListState<Tuple2<Long, Long>> firstWriteMsState;
    private transient TreeSet<Long> commitIdentifiersToCheck;

    public FullChangelogStoreSinkWrite(FileStoreTable table, StateInitializationContext context, String initialCommitUser, IOManager ioManager, boolean isOverwrite, long fullCompactionThresholdMs) throws Exception {
        super(table, context, initialCommitUser, ioManager, isOverwrite);
        this.fullCompactionThresholdMs = fullCompactionThresholdMs;
        this.currentWrittenBuckets = new HashSet<Tuple2<BinaryRowData, Integer>>();
        TupleSerializer writtenBucketStateSerializer = new TupleSerializer(Tuple3.class, new TypeSerializer[]{LongSerializer.INSTANCE, new BinaryRowDataSerializer(table.schema().logicalPartitionType().getFieldCount()), IntSerializer.INSTANCE});
        this.writtenBucketState = context.getOperatorStateStore().getListState(new ListStateDescriptor("table_store_written_buckets", (TypeSerializer)writtenBucketStateSerializer));
        this.writtenBuckets = new TreeMap<Long, Set<Tuple2<BinaryRowData, Integer>>>();
        ((Iterable)this.writtenBucketState.get()).forEach(t -> this.writtenBuckets.computeIfAbsent((Long)t.f0, k -> new HashSet()).add(Tuple2.of((Object)t.f1, (Object)t.f2)));
        this.currentFirstWriteMs = null;
        TupleSerializer firstWriteMsStateSerializer = new TupleSerializer(Tuple2.class, new TypeSerializer[]{LongSerializer.INSTANCE, LongSerializer.INSTANCE});
        this.firstWriteMsState = context.getOperatorStateStore().getListState(new ListStateDescriptor("first_write_ms", (TypeSerializer)firstWriteMsStateSerializer));
        this.firstWriteMs = new TreeMap<Long, Long>();
        ((Iterable)this.firstWriteMsState.get()).forEach(t -> this.firstWriteMs.put((Long)t.f0, (Long)t.f1));
        this.commitIdentifiersToCheck = new TreeSet();
    }

    @Override
    public SinkRecord write(RowData rowData) throws Exception {
        SinkRecord sinkRecord = super.write(rowData);
        this.touchBucket(sinkRecord.partition(), sinkRecord.bucket());
        return sinkRecord;
    }

    @Override
    public void compact(BinaryRowData partition, int bucket, boolean fullCompaction) throws Exception {
        super.compact(partition, bucket, fullCompaction);
        this.touchBucket(partition, bucket);
    }

    private void touchBucket(BinaryRowData partition, int bucket) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("touch partition {}, bucket {}", (Object)partition, (Object)bucket);
        }
        if (!this.currentWrittenBuckets.contains(Tuple2.of((Object)partition, (Object)bucket))) {
            this.currentWrittenBuckets.add((Tuple2<BinaryRowData, Integer>)Tuple2.of((Object)partition.copy(), (Object)bucket));
        }
        if (this.currentFirstWriteMs == null) {
            this.currentFirstWriteMs = System.currentTimeMillis();
        }
    }

    @Override
    public List<Committable> prepareCommit(boolean doCompaction, long checkpointId) throws IOException {
        this.checkSuccessfulFullCompaction();
        if (!this.currentWrittenBuckets.isEmpty()) {
            this.writtenBuckets.computeIfAbsent(checkpointId, k -> new HashSet()).addAll(this.currentWrittenBuckets);
            this.currentWrittenBuckets.clear();
            this.firstWriteMs.putIfAbsent(checkpointId, this.currentFirstWriteMs);
            this.currentFirstWriteMs = null;
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry checkpointIdAndBuckets : this.writtenBuckets.entrySet()) {
                LOG.debug("Written buckets for checkpoint #{} are:", checkpointIdAndBuckets.getKey());
                for (Tuple2 bucket : (Set)checkpointIdAndBuckets.getValue()) {
                    LOG.debug("  * partition {}, bucket {}", bucket.f0, bucket.f1);
                }
            }
        }
        if (!this.writtenBuckets.isEmpty() && System.currentTimeMillis() - this.firstWriteMs.firstEntry().getValue() >= this.fullCompactionThresholdMs) {
            doCompaction = true;
        }
        if (doCompaction) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submit full compaction for checkpoint #{}", (Object)checkpointId);
            }
            this.submitFullCompaction();
            this.commitIdentifiersToCheck.add(checkpointId);
        }
        return super.prepareCommit(doCompaction, checkpointId);
    }

    private void checkSuccessfulFullCompaction() {
        SnapshotManager snapshotManager = this.table.snapshotManager();
        Long latestId = snapshotManager.latestSnapshotId();
        if (latestId == null) {
            return;
        }
        Long earliestId = snapshotManager.earliestSnapshotId();
        if (earliestId == null) {
            return;
        }
        for (long id = latestId.longValue(); id >= earliestId; --id) {
            long commitIdentifier;
            Snapshot snapshot = snapshotManager.snapshot(id);
            if (!snapshot.commitUser().equals(this.commitUser) || snapshot.commitKind() != Snapshot.CommitKind.COMPACT || !this.commitIdentifiersToCheck.contains(commitIdentifier = snapshot.commitIdentifier())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found full compaction snapshot #{} with identifier {}", (Object)id, (Object)commitIdentifier);
            }
            this.writtenBuckets.headMap(commitIdentifier, true).clear();
            this.firstWriteMs.headMap(commitIdentifier, true).clear();
            this.commitIdentifiersToCheck.headSet(commitIdentifier).clear();
            break;
        }
    }

    private void submitFullCompaction() {
        HashSet compactedBuckets = new HashSet();
        this.writtenBuckets.forEach((checkpointId, buckets) -> {
            for (Tuple2 bucket : buckets) {
                if (compactedBuckets.contains(bucket)) continue;
                compactedBuckets.add(bucket);
                try {
                    this.write.compact((BinaryRowData)bucket.f0, (Integer)bucket.f1, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        ArrayList<Tuple3> writtenBucketList = new ArrayList<Tuple3>();
        for (Map.Entry entry : this.writtenBuckets.entrySet()) {
            for (Tuple2 bucket : (Set)entry.getValue()) {
                writtenBucketList.add(Tuple3.of(entry.getKey(), (Object)bucket.f0, (Object)bucket.f1));
            }
        }
        this.writtenBucketState.update(writtenBucketList);
        ArrayList<Tuple2> firstWriteMsList = new ArrayList<Tuple2>();
        for (Map.Entry entry : this.firstWriteMs.entrySet()) {
            firstWriteMsList.add(Tuple2.of(entry.getKey(), entry.getValue()));
        }
        this.firstWriteMsState.update(firstWriteMsList);
    }
}

