/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.compact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.store.file.io.DataFileMeta;

public class CompactResult {
    private final List<DataFileMeta> before;
    private final List<DataFileMeta> after;
    private final List<DataFileMeta> changelog;

    public CompactResult() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public CompactResult(DataFileMeta before, DataFileMeta after) {
        this(Collections.singletonList(before), Collections.singletonList(after));
    }

    public CompactResult(List<DataFileMeta> before, List<DataFileMeta> after) {
        this(before, after, Collections.emptyList());
    }

    public CompactResult(List<DataFileMeta> before, List<DataFileMeta> after, List<DataFileMeta> changelog) {
        this.before = new ArrayList<DataFileMeta>(before);
        this.after = new ArrayList<DataFileMeta>(after);
        this.changelog = new ArrayList<DataFileMeta>(changelog);
    }

    public List<DataFileMeta> before() {
        return this.before;
    }

    public List<DataFileMeta> after() {
        return this.after;
    }

    public List<DataFileMeta> changelog() {
        return this.changelog;
    }

    public void merge(CompactResult that) {
        this.before.addAll(that.before);
        this.after.addAll(that.after);
        this.changelog.addAll(that.changelog);
    }
}

