/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@PublicEvolving
public interface TypeSerializerSnapshot<T> {
    public int getCurrentVersion();

    public void writeSnapshot(DataOutputView var1) throws IOException;

    public void readSnapshot(int var1, DataInputView var2, ClassLoader var3) throws IOException;

    public TypeSerializer<T> restoreSerializer();

    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> var1);

    public static void writeVersionedSnapshot(DataOutputView out, TypeSerializerSnapshot<?> snapshot) throws IOException {
        out.writeUTF(snapshot.getClass().getName());
        out.writeInt(snapshot.getCurrentVersion());
        snapshot.writeSnapshot(out);
    }

    public static <T> TypeSerializerSnapshot<T> readVersionedSnapshot(DataInputView in, ClassLoader cl) throws IOException {
        TypeSerializerSnapshot snapshot = TypeSerializerSnapshotSerializationUtil.readAndInstantiateSnapshotClass(in, cl);
        int version = in.readInt();
        if (version == 2052310256 && !(snapshot instanceof TypeSerializerConfigSnapshot)) {
            TypeSerializerSerializationUtil.tryReadSerializer(in, cl, true);
            version = in.readInt();
        }
        snapshot.readSnapshot(version, in, cl);
        return snapshot;
    }
}

