/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

public final class FileUploads
implements AutoCloseable {
    @Nullable
    private final Path uploadDirectory;
    public static final FileUploads EMPTY = new FileUploads();

    private FileUploads() {
        this.uploadDirectory = null;
    }

    public FileUploads(@Nonnull Path uploadDirectory) {
        Preconditions.checkNotNull(uploadDirectory, "UploadDirectory must not be null.");
        Preconditions.checkArgument(Files.exists(uploadDirectory, new LinkOption[0]), "UploadDirectory does not exist.");
        Preconditions.checkArgument(Files.isDirectory(uploadDirectory, new LinkOption[0]), "UploadDirectory is not a directory.");
        Preconditions.checkArgument(uploadDirectory.isAbsolute(), "UploadDirectory is not absolute.");
        this.uploadDirectory = uploadDirectory;
    }

    public Collection<File> getUploadedFiles() throws IOException {
        if (this.uploadDirectory == null) {
            return Collections.emptyList();
        }
        FileAdderVisitor visitor = new FileAdderVisitor();
        Files.walkFileTree(this.uploadDirectory, visitor);
        return Collections.unmodifiableCollection(visitor.getContainedFiles());
    }

    @Override
    public void close() throws IOException {
        if (this.uploadDirectory != null) {
            FileUtils.deleteDirectory(this.uploadDirectory.toFile());
        }
    }

    private static final class FileAdderVisitor
    extends SimpleFileVisitor<Path> {
        private final Collection<File> files = new ArrayList<File>(4);

        Collection<File> getContainedFiles() {
            return this.files;
        }

        FileAdderVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileVisitResult result = super.visitFile(file, attrs);
            this.files.add(file.toFile());
            return result;
        }
    }
}

