/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.net.DelegatingGuacamoleTunnel;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.FilteredGuacamoleReader;
import org.apache.guacamole.protocol.GuacamoleFilter;
import org.apache.guacamole.tunnel.InputStreamInterceptingFilter;
import org.apache.guacamole.tunnel.OutputStreamInterceptingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamInterceptingTunnel
extends DelegatingGuacamoleTunnel {
    private static final Logger logger = LoggerFactory.getLogger(StreamInterceptingTunnel.class);
    private final InputStreamInterceptingFilter inputStreamFilter = new InputStreamInterceptingFilter((GuacamoleTunnel)this);
    private final OutputStreamInterceptingFilter outputStreamFilter = new OutputStreamInterceptingFilter((GuacamoleTunnel)this);

    public StreamInterceptingTunnel(GuacamoleTunnel tunnel) {
        super(tunnel);
    }

    public void interceptStream(int index, OutputStream stream) throws GuacamoleException {
        logger.debug("Intercepting output stream #{} of tunnel \"{}\".", (Object)index, (Object)this.getUUID());
        try {
            this.outputStreamFilter.interceptStream(index, (Closeable)new BufferedOutputStream(stream));
        }
        finally {
            logger.debug("Intercepted output stream #{} of tunnel \"{}\" ended.", (Object)index, (Object)this.getUUID());
        }
    }

    public void interceptStream(int index, InputStream stream) throws GuacamoleException {
        logger.debug("Intercepting input stream #{} of tunnel \"{}\".", (Object)index, (Object)this.getUUID());
        try {
            this.inputStreamFilter.interceptStream(index, (Closeable)new BufferedInputStream(stream));
        }
        finally {
            logger.debug("Intercepted input stream #{} of tunnel \"{}\" ended.", (Object)index, (Object)this.getUUID());
        }
    }

    public GuacamoleReader acquireReader() {
        GuacamoleReader reader = super.acquireReader();
        reader = new FilteredGuacamoleReader(reader, (GuacamoleFilter)this.inputStreamFilter);
        reader = new FilteredGuacamoleReader(reader, (GuacamoleFilter)this.outputStreamFilter);
        return reader;
    }

    public synchronized void close() throws GuacamoleException {
        try {
            super.close();
        }
        finally {
            this.inputStreamFilter.closeAllInterceptedStreams();
            this.outputStreamFilter.closeAllInterceptedStreams();
        }
    }
}

