/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: cli.proto

package org.apache.ignite.raft.jraft.rpc;

import java.util.Collection;
import org.apache.ignite.raft.jraft.RaftMessageGroup;
import org.apache.ignite.network.annotations.Transferable;
import org.apache.ignite.raft.jraft.RaftMessageGroup.RpcClientMessageGroup;

public final class CliRequests {
    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.ADD_PEER_REQUEST)
    public interface AddPeerRequest extends Message {
        String groupId();

        String leaderId();

        String peerId();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.ADD_PEER_RESPONSE)
    public interface AddPeerResponse extends Message {
        Collection<String> oldPeersList();

        Collection<String> newPeersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.REMOVE_PEER_REQUEST)
    public interface RemovePeerRequest extends Message {
        String groupId();

        String leaderId();

        String peerId();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.REMOVE_PEER_RESPONSE)
    public interface RemovePeerResponse extends Message {
        Collection<String> oldPeersList();

        Collection<String> newPeersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.CHANGE_PEERS_REQUEST)
    public interface ChangePeersRequest extends Message {
        String groupId();

        String leaderId();

        Collection<String> newPeersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.CHANGE_PEERS_RESPONSE)
    public interface ChangePeersResponse extends Message {
        Collection<String> oldPeersList();

        Collection<String> newPeersList();
    }

    @Transferable(value = RpcClientMessageGroup.CHANGE_PEERS_ASYNC_REQUEST)
    public interface ChangePeersAsyncRequest extends Message {
        String groupId();

        String leaderId();

        Collection<String> newPeersList();

        long term();
    }

    @Transferable(value = RpcClientMessageGroup.CHANGE_PEERS_ASYNC_RESPONSE)
    public interface ChangePeersAsyncResponse extends Message {
        Collection<String> oldPeersList();

        Collection<String> newPeersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.SNAPSHOT_REQUEST)
    public interface SnapshotRequest extends Message {
        String groupId();

        String peerId();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.RESET_PEER_REQUEST)
    public interface ResetPeerRequest extends Message {
        String groupId();

        String peerId();

        Collection<String> oldPeersList();

        Collection<String> newPeersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.TRANSFER_LEADER_REQUEST)
    public interface TransferLeaderRequest extends Message {
        String groupId();

        String leaderId();

        String peerId();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.GET_LEADER_REQUEST)
    public interface GetLeaderRequest extends Message {
        String groupId();

        String peerId();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.GET_LEADER_RESPONSE)
    public interface GetLeaderResponse extends Message {
        String leaderId();

        long currentTerm();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.GET_PEERS_REQUEST)
    public interface GetPeersRequest extends Message {
        String groupId();

        String leaderId();

        boolean onlyAlive();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.GET_PEERS_RESPONSE)
    public interface GetPeersResponse extends Message {
        Collection<String> peersList();

        Collection<String> learnersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.ADD_LEARNERS_REQUEST)
    public interface AddLearnersRequest extends Message {
        String groupId();

        String leaderId();

        Collection<String> learnersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.REMOVE_LEARNERS_REQUEST)
    public interface RemoveLearnersRequest extends Message {
        String groupId();

        String leaderId();

        Collection<String> learnersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.RESET_LEARNERS_REQUEST)
    public interface ResetLearnersRequest extends Message {
        String groupId();

        String leaderId();

        Collection<String> learnersList();
    }

    @Transferable(value = RaftMessageGroup.RpcClientMessageGroup.LEARNERS_OP_RESPONSE)
    public interface LearnersOpResponse extends Message {
        Collection<String> oldLearnersList();

        Collection<String> newLearnersList();
    }
}
