/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.nio.ByteBuffer;
import java.util.stream.IntStream;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTuplePrefixBuilder;
import org.apache.ignite.internal.schema.BinaryConverter;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;

public final class RowConverter {
    public static BinaryTupleSchema createIndexRowSchema(TableDescriptor tableDescriptor, ImmutableIntList idxColumnMapping) {
        BinaryTupleSchema.Element[] elements = (BinaryTupleSchema.Element[])IntStream.of(idxColumnMapping.toIntArray()).mapToObj(tableDescriptor::columnDescriptor).map(colDesc -> new BinaryTupleSchema.Element(colDesc.physicalType(), true)).toArray(BinaryTupleSchema.Element[]::new);
        return BinaryTupleSchema.create((BinaryTupleSchema.Element[])elements);
    }

    public static <RowT> BinaryTuplePrefix toBinaryTuplePrefix(ExecutionContext<RowT> ectx, BinaryTupleSchema binarySchema, ImmutableIntList idxColumnMapper, RowHandler.RowFactory<RowT> factory, RowT searchRow) {
        RowHandler<RowT> handler = factory.handler();
        int prefixColumnsCount = binarySchema.elementCount();
        int specifiedCols = 0;
        for (int i = 0; i < prefixColumnsCount; ++i) {
            if (handler.get(idxColumnMapper.get(i), searchRow) == ectx.unspecifiedValue()) continue;
            ++specifiedCols;
        }
        BinaryTuplePrefixBuilder tupleBuilder = new BinaryTuplePrefixBuilder(specifiedCols, prefixColumnsCount);
        return new BinaryTuplePrefix(binarySchema, RowConverter.toByteBuffer(ectx, binarySchema, idxColumnMapper, handler, (BinaryTupleBuilder)tupleBuilder, searchRow));
    }

    public static <RowT> BinaryTuple toBinaryTuple(ExecutionContext<RowT> ectx, BinaryTupleSchema binarySchema, ImmutableIntList idxColumnMapper, RowHandler.RowFactory<RowT> factory, RowT searchRow) {
        RowHandler<RowT> handler = factory.handler();
        int prefixColumnsCount = binarySchema.elementCount();
        BinaryTupleBuilder tupleBuilder = new BinaryTupleBuilder(prefixColumnsCount, binarySchema.hasNullableElements());
        return new BinaryTuple(binarySchema, RowConverter.toByteBuffer(ectx, binarySchema, idxColumnMapper, handler, tupleBuilder, searchRow));
    }

    private static <RowT> ByteBuffer toByteBuffer(ExecutionContext<RowT> ectx, BinaryTupleSchema binarySchema, ImmutableIntList idxColumnMapper, RowHandler<RowT> handler, BinaryTupleBuilder tupleBuilder, RowT searchRow) {
        Object val;
        for (int i = 0; i < binarySchema.elementCount() && (val = handler.get(idxColumnMapper.get(i), searchRow)) != ectx.unspecifiedValue(); ++i) {
            BinaryTupleSchema.Element element = binarySchema.element(i);
            val = TypeUtils.fromInternal(ectx, val, NativeTypeSpec.toClass((NativeTypeSpec)element.typeSpec(), (boolean)element.nullable()));
            BinaryConverter.appendValue((BinaryTupleBuilder)tupleBuilder, (BinaryTupleSchema.Element)element, (Object)val);
        }
        return tupleBuilder.build();
    }
}

