/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.prepare.PlannerPhase;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.util.HintUtils;

public class PlannerHelper {
    private static final IgniteLogger LOG = Loggers.forClass(PlannerHelper.class);

    private PlannerHelper() {
    }

    public static IgniteRel optimize(SqlNode sqlNode, IgnitePlanner planner) {
        try {
            RelRoot root = planner.rel(sqlNode);
            Object rel = root.rel;
            if (HintUtils.containsDisabledRules((List<RelHint>)root.hints)) {
                planner.setDisabledRules(HintUtils.disabledRules((List<RelHint>)root.hints));
            }
            rel = planner.transform(PlannerPhase.HEP_DECORRELATE, rel.getTraitSet(), (RelNode)rel);
            rel = planner.replaceCorrelatesCollisions((RelNode)rel);
            rel = planner.trimUnusedFields((RelRoot)root.withRel((RelNode)rel)).rel;
            rel = planner.transform(PlannerPhase.HEP_FILTER_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            rel = planner.transform(PlannerPhase.HEP_PROJECT_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            RelTraitSet desired = rel.getCluster().traitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()).replace((RelTrait)(root.collation == null ? RelCollations.EMPTY : root.collation)).simplify();
            IgniteRel igniteRel = (IgniteRel)planner.transform(PlannerPhase.OPTIMIZATION, desired, (RelNode)rel);
            if (!root.isRefTrivial()) {
                ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
                RexBuilder rexBuilder = igniteRel.getCluster().getRexBuilder();
                Iterator iterator = Pair.left((List)root.fields).iterator();
                while (iterator.hasNext()) {
                    int field = (Integer)iterator.next();
                    projects.add(rexBuilder.makeInputRef((RelNode)igniteRel, field));
                }
                igniteRel = new IgniteProject(igniteRel.getCluster(), desired, (RelNode)igniteRel, projects, root.validatedRowType);
            }
            return igniteRel;
        }
        catch (Throwable ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unexpected error at query optimizer", ex);
                LOG.debug(planner.dump(), new Object[0]);
            }
            throw ex;
        }
    }
}

