/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.io;

import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.lang.IgniteStringBuilder;

public class PartitionMetaIo
extends PageIo {
    private static final int LAST_APPLIED_INDEX_OFF = 40;
    private static final int ROW_VERSION_FREE_LIST_ROOT_PAGE_ID_OFF = 48;
    private static final int INDEX_COLUMNS_FREE_LIST_ROOT_PAGE_ID_OFF = 56;
    private static final int VERSION_CHAIN_TREE_ROOT_PAGE_ID_OFF = 64;
    public static final int INDEX_TREE_META_PAGE_ID_OFF = 72;
    private static final int PAGE_COUNT_OFF = 80;
    public static final short T_TABLE_PARTITION_META_IO = 7;
    public static final IoVersions<PartitionMetaIo> VERSIONS = new IoVersions((PageIo[])new PartitionMetaIo[]{new PartitionMetaIo(1)});

    protected PartitionMetaIo(int ver) {
        super(7, ver, (byte)2);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setLastAppliedIndex(pageAddr, 0L);
        this.setRowVersionFreeListRootPageId(pageAddr, 0L);
        this.setIndexColumnsFreeListRootPageId(pageAddr, 0L);
        this.setVersionChainTreeRootPageId(pageAddr, 0L);
        this.setIndexTreeMetaPageId(pageAddr, 0L);
        this.setPageCount(pageAddr, 0);
    }

    public void setLastAppliedIndex(long pageAddr, long lastAppliedIndex) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 40, lastAppliedIndex);
    }

    public long getLastAppliedIndex(long pageAddr) {
        return PageUtils.getLong(pageAddr, 40);
    }

    public void setRowVersionFreeListRootPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 48, pageId);
    }

    public long getRowVersionFreeListRootPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 48);
    }

    public void setIndexColumnsFreeListRootPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 56, pageId);
    }

    public long getIndexColumnsFreeListRootPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 56);
    }

    public void setVersionChainTreeRootPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 64, pageId);
    }

    public long getVersionChainTreeRootPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 64);
    }

    public void setIndexTreeMetaPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 72, pageId);
    }

    public long getIndexTreeMetaPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 72);
    }

    public void setPageCount(long pageAddr, int pageCount) {
        this.assertPageType(pageAddr);
        PageUtils.putInt(pageAddr, 80, pageCount);
    }

    public int getPageCount(long pageAddr) {
        return PageUtils.getInt(pageAddr, 80);
    }

    @Override
    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("TablePartitionMeta [").nl().app("lastAppliedIndex=").app(this.getLastAppliedIndex(addr)).nl().app(", rowVersionFreeListRootPageId=").appendHex(this.getRowVersionFreeListRootPageId(addr)).nl().app(", indexColumnsFreeListRootPageId(=").appendHex(this.getIndexColumnsFreeListRootPageId(addr)).nl().app(", versionChainTreeRootPageId=").appendHex(this.getVersionChainTreeRootPageId(addr)).nl().app(", indexTreeMetaPageId=").appendHex(this.getIndexTreeMetaPageId(addr)).nl().app(", pageCount=").app(this.getPageCount(addr)).nl().app(']');
    }
}

