/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.Collection;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.MetricRegistry;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.configuration.MetricConfiguration;
import org.apache.ignite.internal.metrics.configuration.MetricView;
import org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterConfiguration;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class MetricManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(MetricManager.class);
    private final MetricRegistry registry;
    private final MetricProvider metricsProvider;
    private final Map<String, MetricExporter> enabledMetricExporters = new ConcurrentHashMap<String, MetricExporter>();
    private Map<String, MetricExporter> availableExporters;
    private MetricConfiguration metricConfiguration;

    public MetricManager() {
        this.registry = new MetricRegistry();
        this.metricsProvider = new MetricProvider(this.registry);
    }

    public void configure(MetricConfiguration metricConfiguration) {
        assert (this.metricConfiguration == null) : "Metric manager must be configured only once, on the start of the node";
        this.metricConfiguration = metricConfiguration;
    }

    public void start() {
        this.start(MetricManager.loadExporters());
    }

    @VisibleForTesting
    public void start(Map<String, MetricExporter> availableExporters) {
        this.availableExporters = availableExporters;
        MetricView conf = (MetricView)this.metricConfiguration.value();
        for (String exporterName : conf.exporters().namedListKeys()) {
            this.checkAndStartExporter(exporterName, (ExporterView)((ExporterConfiguration)this.metricConfiguration.exporters().get(exporterName)).value());
        }
        this.metricConfiguration.exporters().listenElements((ConfigurationNamedListListener)new ExporterConfigurationListener());
    }

    public void stop() throws Exception {
        for (MetricExporter metricExporter : this.enabledMetricExporters.values()) {
            metricExporter.stop();
        }
        this.enabledMetricExporters.clear();
    }

    public void registerSource(MetricSource src) {
        this.registry.registerSource(src);
    }

    public void unregisterSource(MetricSource src) {
        this.registry.unregisterSource(src);
    }

    public void unregisterSource(String srcName) {
        this.registry.unregisterSource(srcName);
    }

    public MetricSet enable(MetricSource src) {
        MetricSet enabled = this.registry.enable(src);
        if (enabled != null) {
            this.enabledMetricExporters.values().forEach(e -> e.addMetricSet(enabled));
        }
        return enabled;
    }

    public MetricSet enable(String srcName) {
        MetricSet enabled = this.registry.enable(srcName);
        if (enabled != null) {
            this.enabledMetricExporters.values().forEach(e -> e.addMetricSet(enabled));
        }
        return enabled;
    }

    public static Map<String, MetricExporter> loadExporters() {
        ClassLoader clsLdr = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(MetricExporter.class, clsLdr).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(e -> e.name(), Function.identity()));
    }

    public void disable(MetricSource src) {
        this.registry.disable(src);
        this.enabledMetricExporters.values().forEach(e -> e.removeMetricSet(src.name()));
    }

    public void disable(String srcName) {
        this.registry.disable(srcName);
        this.enabledMetricExporters.values().forEach(e -> e.removeMetricSet(srcName));
    }

    @NotNull
    public IgniteBiTuple<Map<String, MetricSet>, Long> metricSnapshot() {
        return this.registry.metricSnapshot();
    }

    public Collection<MetricSource> metricSources() {
        return this.registry.metricSources();
    }

    private <T extends ExporterView> void checkAndStartExporter(String exporterName, T exporterConfiguration) {
        MetricExporter exporter = this.availableExporters.get(exporterName);
        if (exporter != null) {
            exporter.start(this.metricsProvider, exporterConfiguration);
            this.enabledMetricExporters.put(exporter.name(), exporter);
        } else {
            LOG.warn("Received configuration for unknown metric exporter with the name '" + exporterName + "'", new Object[0]);
        }
    }

    private class ExporterConfigurationListener
    implements ConfigurationNamedListListener<ExporterView> {
        private ExporterConfigurationListener() {
        }

        public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ExporterView> ctx) {
            MetricManager.this.checkAndStartExporter(((ExporterView)ctx.newValue()).exporterName(), (ExporterView)ctx.newValue());
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ExporterView> ctx) {
            MetricExporter removed = MetricManager.this.enabledMetricExporters.remove(((ExporterView)ctx.oldValue()).exporterName());
            if (removed != null) {
                removed.stop();
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ExporterView> ctx) {
            MetricExporter exporter = MetricManager.this.enabledMetricExporters.get(((ExporterView)ctx.newValue()).exporterName());
            if (exporter != null) {
                exporter.reconfigure((ExporterView)ctx.newValue());
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

