/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.cluster.ClusterInitCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.rest.client.api.ClusterManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;
import org.apache.ignite.rest.client.model.InitCommand;

@Singleton
public class ClusterInitCall
implements Call<ClusterInitCallInput, String> {
    @Override
    public DefaultCallOutput<String> execute(ClusterInitCallInput input) {
        ClusterManagementApi client = this.createApiClient(input);
        try {
            client.init(new InitCommand().metaStorageNodes(input.getMetaStorageNodes()).cmgNodes(input.getCmgNodes()).clusterName(input.getClusterName()));
            return DefaultCallOutput.success("Cluster was initialized successfully");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getClusterUrl()));
        }
    }

    private ClusterManagementApi createApiClient(ClusterInitCallInput input) {
        return new ClusterManagementApi(Configuration.getDefaultApiClient().setBasePath(input.getClusterUrl()));
    }
}

