/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.cluster.init;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.cluster.ClusterInitCall;
import org.apache.ignite.internal.cli.call.cluster.ClusterInitCallInput;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.cluster.init.ClusterInitOptions;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Initializes an Ignite cluster"})
public class ClusterInitReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private ClusterInitOptions clusterInitOptions;
    @Inject
    private ClusterInitCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::buildCallInput).then(Flows.fromCall(this.call)).verbose(this.verbose).print().start();
    }

    private ClusterInitCallInput buildCallInput(String clusterUrl) {
        return ClusterInitCallInput.builder().clusterUrl(clusterUrl).fromClusterInitOptions(this.clusterInitOptions).build();
    }
}

