/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.io.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.ignite.internal.client.io.ClientConnection;
import org.apache.ignite.internal.client.io.ClientConnectionStateHandler;
import org.apache.ignite.internal.client.io.ClientMessageHandler;
import org.apache.ignite.lang.IgniteException;

public class NettyClientConnection
implements ClientConnection {
    public static final AttributeKey<NettyClientConnection> ATTR_CONN = AttributeKey.newInstance((String)"CONN");
    private final Channel channel;
    private final ClientMessageHandler msgHnd;
    private final ClientConnectionStateHandler stateHnd;

    public NettyClientConnection(Channel channel, ClientMessageHandler msgHnd, ClientConnectionStateHandler stateHnd) {
        this.channel = channel;
        this.msgHnd = msgHnd;
        this.stateHnd = stateHnd;
        channel.attr(ATTR_CONN).set((Object)this);
    }

    @Override
    public ChannelFuture send(ByteBuf msg) throws IgniteException {
        return this.channel.writeAndFlush((Object)msg);
    }

    @Override
    public ByteBuf getBuffer() {
        return this.channel.alloc().buffer();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    void onMessage(ByteBuf buf) throws IOException {
        this.msgHnd.onMessage(buf);
    }

    void onDisconnected(Exception e) {
        this.stateHnd.onDisconnected(e);
    }
}

