/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.client.sql.ClientStatementBuilder;
import org.apache.ignite.sql.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientStatement
implements Statement {
    private final String query;
    private final String defaultSchema;
    private final Long queryTimeoutMs;
    private final Integer pageSize;
    private final Map<String, Object> properties;

    public ClientStatement(String query, String defaultSchema, Long queryTimeoutMs, Integer pageSize, Map<String, Object> properties) {
        Objects.requireNonNull(query);
        this.query = query;
        this.defaultSchema = defaultSchema;
        this.queryTimeoutMs = queryTimeoutMs;
        this.pageSize = pageSize;
        this.properties = properties;
    }

    @NotNull
    public String query() {
        return this.query;
    }

    public long queryTimeout(@NotNull TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        return this.queryTimeoutMs == null ? 0L : timeUnit.convert(this.queryTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public Long queryTimeoutNullable() {
        return this.queryTimeoutMs;
    }

    public String defaultSchema() {
        return this.defaultSchema;
    }

    public int pageSize() {
        return this.pageSize == null ? 0 : this.pageSize;
    }

    public Integer pageSizeNullable() {
        return this.pageSize;
    }

    @Nullable
    public Object property(@NotNull String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public Statement.StatementBuilder toBuilder() {
        Statement.StatementBuilder builder = new ClientStatementBuilder().query(this.query).defaultSchema(this.defaultSchema);
        if (this.pageSize != null) {
            builder.pageSize(this.pageSize.intValue());
        }
        if (this.queryTimeoutMs != null) {
            builder.queryTimeout(this.queryTimeoutMs.longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.properties != null) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                builder.property(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    public void close() throws Exception {
    }
}

