/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.requests.jdbc.JdbcMetadataCatalog;
import org.apache.ignite.client.handler.requests.jdbc.JdbcQueryCursor;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryEventHandler;
import org.apache.ignite.internal.jdbc.proto.JdbcStatementType;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchPreparedStmntRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.QueryContext;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.QueryValidator;
import org.apache.ignite.internal.sql.engine.exec.QueryValidationException;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlColumnType;

public class JdbcQueryEventHandlerImpl
implements JdbcQueryEventHandler {
    private final QueryProcessor processor;
    private final JdbcMetadataCatalog meta;
    private final ClientResourceRegistry resources;

    public JdbcQueryEventHandlerImpl(QueryProcessor processor, JdbcMetadataCatalog meta, ClientResourceRegistry resources) {
        this.processor = processor;
        this.meta = meta;
        this.resources = resources;
    }

    public CompletableFuture<? extends Response> queryAsync(JdbcQueryExecuteRequest req) {
        if (req.pageSize() <= 0) {
            return CompletableFuture.completedFuture(new JdbcQueryExecuteResult(1, "Invalid fetch size [fetchSize=" + req.pageSize() + "]"));
        }
        QueryContext context = this.createQueryContext(req.getStmtType());
        ArrayList<CompletionStage> results = new ArrayList<CompletionStage>();
        for (CompletableFuture cursorFut : this.processor.queryAsync(context, req.schemaName(), req.sqlQuery(), req.arguments() == null ? ArrayUtils.OBJECT_EMPTY_ARRAY : req.arguments())) {
            results.add(((CompletableFuture)cursorFut.thenApply(cursor -> new JdbcQueryCursor(req.maxRows(), cursor))).thenCompose(cursor -> this.createJdbcResult((AsyncSqlCursor<List<Object>>)cursor, req)));
        }
        if (results.isEmpty()) {
            return CompletableFuture.completedFuture(new JdbcQueryExecuteResult(1, "At least one cursor is expected for query [query=" + req.sqlQuery() + "]"));
        }
        return ((CompletableFuture)CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).thenApply(none -> {
            List actualResults = results.stream().map(CompletableFuture::join).collect(Collectors.toList());
            return new JdbcQueryExecuteResult(actualResults);
        })).exceptionally(t -> {
            results.stream().filter(fut -> !fut.isCompletedExceptionally()).map(CompletableFuture::join).filter(res -> res.cursorId() != null).map(res -> {
                try {
                    return this.resources.remove(res.cursorId()).get(AsyncSqlCursor.class);
                }
                catch (IgniteInternalCheckedException igniteInternalCheckedException) {
                    return null;
                }
            }).filter(Objects::nonNull).forEach(AsyncCursor::closeAsync);
            StringWriter sw = this.getWriterWithStackTrace((Throwable)t);
            return new JdbcQueryExecuteResult(1, "Exception while executing query [query=" + req.sqlQuery() + "]. Error message:" + sw);
        });
    }

    private QueryContext createQueryContext(JdbcStatementType stmtType) {
        if (stmtType == JdbcStatementType.ANY_STATEMENT_TYPE) {
            return QueryContext.of((Object[])new Object[0]);
        }
        QueryValidator validator = plan -> {
            if (plan.type() == QueryPlan.Type.QUERY || plan.type() == QueryPlan.Type.EXPLAIN) {
                if (stmtType == JdbcStatementType.SELECT_STATEMENT_TYPE) {
                    return;
                }
                throw new QueryValidationException("Given statement type does not match that declared by JDBC driver.");
            }
            if (stmtType == JdbcStatementType.UPDATE_STATEMENT_TYPE) {
                return;
            }
            throw new QueryValidationException("Given statement type does not match that declared by JDBC driver.");
        };
        return QueryContext.of((Object[])new Object[]{validator});
    }

    public CompletableFuture<JdbcBatchExecuteResult> batchAsync(JdbcBatchExecuteRequest req) {
        List queries = req.queries();
        IntArrayList counters = new IntArrayList(req.queries().size());
        CompletionStage<Object> tail = CompletableFuture.completedFuture(counters);
        for (String query : queries) {
            tail = tail.thenCompose(list -> this.executeAndCollectUpdateCount(req.schemaName(), query, ArrayUtils.OBJECT_EMPTY_ARRAY).thenApply(cnt -> {
                list.add(cnt > Integer.MAX_VALUE ? -2 : cnt.intValue());
                return list;
            }));
        }
        return tail.handle((ignored, t) -> {
            if (t != null) {
                return this.handleBatchException((Throwable)t, (String)queries.get(counters.size()), counters.toIntArray());
            }
            return new JdbcBatchExecuteResult(counters.toIntArray());
        });
    }

    public CompletableFuture<JdbcBatchExecuteResult> batchPrepStatementAsync(JdbcBatchPreparedStmntRequest req) {
        List argList = req.getArgs();
        IntArrayList counters = new IntArrayList(req.getArgs().size());
        CompletionStage<Object> tail = CompletableFuture.completedFuture(counters);
        for (Object[] args : argList) {
            tail = tail.thenCompose(list -> this.executeAndCollectUpdateCount(req.schemaName(), req.getQuery(), args).thenApply(cnt -> {
                list.add(cnt > Integer.MAX_VALUE ? -2 : cnt.intValue());
                return list;
            }));
        }
        return tail.handle((ignored, t) -> {
            if (t != null) {
                return this.handleBatchException((Throwable)t, req.getQuery(), counters.toIntArray());
            }
            return new JdbcBatchExecuteResult(counters.toIntArray());
        });
    }

    private CompletableFuture<Long> executeAndCollectUpdateCount(String schema, String sql, Object[] arg) {
        QueryContext context = this.createQueryContext(JdbcStatementType.UPDATE_STATEMENT_TYPE);
        List cursors = this.processor.queryAsync(context, schema, sql, arg);
        if (cursors.size() != 1) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException("Multi statement queries are not supported in batching"));
        }
        return ((CompletableFuture)cursors.get(0)).thenCompose(cursor -> cursor.requestNextAsync(1).thenApply(batch -> (Long)((List)batch.items().get(0)).get(0)));
    }

    private JdbcBatchExecuteResult handleBatchException(Throwable e, String query, int[] counters) {
        StringWriter sw = this.getWriterWithStackTrace(e);
        Object error = e instanceof ClassCastException ? "Unexpected result. Not an upsert statement? [query=" + query + "] Error message:" + sw : sw.toString();
        return new JdbcBatchExecuteResult(1, 1, (String)error, counters);
    }

    public CompletableFuture<JdbcMetaTablesResult> tablesMetaAsync(JdbcMetaTablesRequest req) {
        return this.meta.getTablesMeta(req.schemaName(), req.tableName(), req.tableTypes()).thenApply(JdbcMetaTablesResult::new);
    }

    public CompletableFuture<JdbcMetaColumnsResult> columnsMetaAsync(JdbcMetaColumnsRequest req) {
        return this.meta.getColumnsMeta(req.schemaName(), req.tableName(), req.columnName()).thenApply(JdbcMetaColumnsResult::new);
    }

    public CompletableFuture<JdbcMetaSchemasResult> schemasMetaAsync(JdbcMetaSchemasRequest req) {
        return this.meta.getSchemasMeta(req.schemaName()).thenApply(JdbcMetaSchemasResult::new);
    }

    public CompletableFuture<JdbcMetaPrimaryKeysResult> primaryKeysMetaAsync(JdbcMetaPrimaryKeysRequest req) {
        return this.meta.getPrimaryKeys(req.schemaName(), req.tableName()).thenApply(JdbcMetaPrimaryKeysResult::new);
    }

    private StringWriter getWriterWithStackTrace(Throwable t) {
        String message = ExceptionUtils.unwrapCause((Throwable)t).getMessage();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(message);
        return sw;
    }

    private CompletionStage<JdbcQuerySingleResult> createJdbcResult(AsyncSqlCursor<List<Object>> cur, JdbcQueryExecuteRequest req) {
        return cur.requestNextAsync(req.pageSize()).thenApply(batch -> {
            boolean hasNext = batch.hasMore();
            switch (cur.queryType()) {
                case EXPLAIN: 
                case QUERY: {
                    long cursorId;
                    try {
                        cursorId = this.resources.put(new ClientResource(cur, () -> ((AsyncSqlCursor)cur).closeAsync()));
                    }
                    catch (IgniteInternalCheckedException e) {
                        cur.closeAsync();
                        return new JdbcQuerySingleResult(1, "Unable to store query cursor.");
                    }
                    return new JdbcQuerySingleResult(cursorId, batch.items(), !hasNext);
                }
                case DML: {
                    if (!this.validateDmlResult(cur.metadata(), hasNext)) {
                        return new JdbcQuerySingleResult(1, "Unexpected result for DML [query=" + req.sqlQuery() + "]");
                    }
                    return new JdbcQuerySingleResult(((Long)((List)batch.items().get(0)).get(0)).longValue());
                }
                case DDL: {
                    return new JdbcQuerySingleResult(0L);
                }
            }
            return new JdbcQuerySingleResult(1002, "Query type is not supported yet [queryType=" + cur.queryType() + "]");
        });
    }

    private boolean validateDmlResult(ResultSetMetadata meta, boolean next) {
        if (next) {
            return false;
        }
        if (meta.columns().size() != 1) {
            return false;
        }
        return ((ColumnMetadata)meta.columns().get(0)).type() == SqlColumnType.INT64;
    }
}

