/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.hll.BucketIterator;
import com.yahoo.sketches.hll.Fields;
import com.yahoo.sketches.hll.HarmonicNumbers;
import com.yahoo.sketches.hll.HllSketchBuilder;
import com.yahoo.sketches.hll.HllUtils;
import com.yahoo.sketches.hll.Interpolation;
import com.yahoo.sketches.hll.Preamble;
import java.nio.charset.StandardCharsets;

public class HllSketch {
    private static final double HLL_REL_ERROR_NUMER = 1.04;
    private Fields.UpdateCallback updateCallback;
    private final Preamble preamble;
    private Fields fields;

    public static HllSketchBuilder builder() {
        return new HllSketchBuilder();
    }

    public HllSketch(Fields fields) {
        this.fields = fields;
        this.updateCallback = new Fields.UpdateCallback(){

            @Override
            public void bucketUpdated(int bucket, byte oldVal, byte newVal) {
            }
        };
        this.preamble = fields.getPreamble();
    }

    public void update(long datum) {
        long[] data = new long[]{datum};
        this.updateWithHash(MurmurHash3.hash(data, 9001L));
    }

    public void update(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        this.updateWithHash(MurmurHash3.hash(data, 9001L));
    }

    public void update(String datum) {
        if (datum == null || datum.isEmpty()) {
            return;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        this.updateWithHash(MurmurHash3.hash(data, 9001L));
    }

    public void update(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.updateWithHash(MurmurHash3.hash(data, 9001L));
    }

    public void update(int[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.updateWithHash(MurmurHash3.hash(data, 9001L));
    }

    public void update(long[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.updateWithHash(MurmurHash3.hash(data, 9001L));
    }

    public double getEstimate() {
        int configK;
        double rawEst = this.getRawEstimate();
        byte logK = this.preamble.getLogConfigK();
        double[] x_arr = Interpolation.interpolation_x_arrs[logK - 7];
        double[] y_arr = Interpolation.interpolation_y_arrs[logK - 7];
        if (rawEst < x_arr[0]) {
            return 0.0;
        }
        if (rawEst > x_arr[x_arr.length - 1]) {
            return rawEst;
        }
        double adjEst = Interpolation.cubicInterpolateUsingTable(x_arr, y_arr, rawEst);
        if (adjEst > 3.0 * (double)(configK = this.preamble.getConfigK())) {
            return adjEst;
        }
        double linEst = this.getLinearEstimate();
        double avgEst = (adjEst + linEst) / 2.0;
        if (avgEst > 0.64 * (double)configK) {
            return adjEst;
        }
        return linEst;
    }

    public double getUpperBound(double numStdDevs) {
        return this.getEstimate() / (1.0 - this.eps(numStdDevs));
    }

    public double getLowerBound(double numStdDevs) {
        double lowerBound = this.getEstimate() / (1.0 + this.eps(numStdDevs));
        double numNonZeros = this.preamble.getConfigK();
        if (lowerBound < (numNonZeros -= (double)this.numBucketsAtZero())) {
            return numNonZeros;
        }
        return lowerBound;
    }

    private double getRawEstimate() {
        int numBuckets = this.preamble.getConfigK();
        double correctionFactor = 0.7213 / (1.0 + 1.079 / (double)numBuckets);
        correctionFactor *= (double)(numBuckets * numBuckets);
        return correctionFactor /= this.inversePowerOf2Sum();
    }

    private double getLinearEstimate() {
        int configK = this.preamble.getConfigK();
        long longV = this.numBucketsAtZero();
        if (longV == 0L) {
            return (double)configK * Math.log((double)configK / 0.5);
        }
        return (double)configK * (HarmonicNumbers.harmonicNumber(configK) - HarmonicNumbers.harmonicNumber(longV));
    }

    public HllSketch union(HllSketch that) {
        this.fields = that.fields.unionInto(this.fields, this.updateCallback);
        return this;
    }

    private void updateWithHash(long[] hash) {
        byte newValue = (byte)(Long.numberOfLeadingZeros(hash[1]) + 1);
        int slotno = (int)hash[0] & this.preamble.getConfigK() - 1;
        this.fields = this.fields.updateBucket(slotno, newValue, this.updateCallback);
    }

    private double eps(double numStdDevs) {
        return numStdDevs * 1.04 / Math.sqrt(this.preamble.getConfigK());
    }

    public byte[] toByteArray() {
        int numBytes = (this.preamble.getPreambleLongs() << 3) + this.fields.numBytesToSerialize();
        byte[] retVal = new byte[numBytes];
        this.fields.intoByteArray(retVal, this.preamble.intoByteArray(retVal, 0));
        return retVal;
    }

    public byte[] toByteArrayNoPreamble() {
        byte[] retVal = new byte[this.fields.numBytesToSerialize()];
        this.fields.intoByteArray(retVal, 0);
        return retVal;
    }

    public HllSketch asCompact() {
        return new HllSketch(this.fields.toCompact());
    }

    public int numBuckets() {
        return this.preamble.getConfigK();
    }

    public Preamble getPreamble() {
        return this.preamble;
    }

    protected final void setUpdateCallback(Fields.UpdateCallback updateCallback) {
        this.updateCallback = updateCallback;
    }

    protected double inversePowerOf2Sum() {
        return HllUtils.computeInvPow2Sum(this.numBuckets(), this.fields.getBucketIterator());
    }

    protected int numBucketsAtZero() {
        int retVal = 0;
        int count = 0;
        BucketIterator bucketIter = this.fields.getBucketIterator();
        while (bucketIter.next()) {
            if (bucketIter.getValue() == 0) {
                ++retVal;
            }
            ++count;
        }
        return retVal += this.fields.getPreamble().getConfigK() - count;
    }
}

