/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public final class IgniteNameUtils {
    private IgniteNameUtils() {
    }

    public static String parseSimpleName(String name) {
        if (StringUtils.nullOrEmpty(name)) {
            return name;
        }
        Tokenizer tokenizer = new Tokenizer(name);
        String parsedName = tokenizer.nextToken();
        if (tokenizer.hasNext()) {
            throw new IgniteInternalException(ErrorGroups.Common.ILLEGAL_ARGUMENT_ERR, "Fully qualified name is not expected [name=" + name + "]");
        }
        return parsedName;
    }

    public static String canonicalName(String schemaName, String objectName) {
        return IgniteNameUtils.quote(schemaName) + "." + IgniteNameUtils.quote(objectName);
    }

    public static String quote(String name) {
        return "\"" + name + "\"";
    }

    private static class Tokenizer {
        private int currentPosition;
        private final String source;

        public Tokenizer(String source) {
            this.source = source;
        }

        public boolean hasNext() {
            return this.currentPosition < this.source.length();
        }

        @Nullable
        public String nextToken() {
            boolean quoted;
            if (!this.hasNext()) {
                return null;
            }
            boolean bl = quoted = this.source.charAt(this.currentPosition) == '\"';
            if (quoted) {
                ++this.currentPosition;
            }
            int start = this.currentPosition;
            StringBuilder sb = new StringBuilder();
            while (this.currentPosition < this.source.length()) {
                if (this.currentChar() == '\"') {
                    if (!quoted) {
                        this.throwMalformedNameException();
                    }
                    if (this.hasNextChar() && this.nextChar() == '\"') {
                        sb.append(this.source, start, this.currentPosition + 1);
                        this.currentPosition += 2;
                        start = this.currentPosition;
                    } else {
                        if (!this.hasNextChar() || this.nextChar() == '.') {
                            sb.append(this.source, start, this.currentPosition);
                            this.currentPosition += 2;
                            return sb.toString();
                        }
                        this.throwMalformedNameException();
                    }
                } else if (!(quoted || this.currentChar() != '.' && this.currentChar() != ' ')) {
                    sb.append(this.source, start, this.currentPosition);
                    ++this.currentPosition;
                    return sb.toString().toUpperCase();
                }
                ++this.currentPosition;
            }
            if (quoted) {
                this.throwMalformedNameException();
            }
            return this.source.substring(start).toUpperCase();
        }

        private char currentChar() {
            return this.source.charAt(this.currentPosition);
        }

        private boolean hasNextChar() {
            return this.currentPosition + 1 < this.source.length();
        }

        private char nextChar() {
            return this.source.charAt(this.currentPosition + 1);
        }

        private void throwMalformedNameException() {
            throw new IgniteInternalException(ErrorGroups.Common.ILLEGAL_ARGUMENT_ERR, "Malformed name [name=" + this.source + ", pos=" + this.currentPosition + "]");
        }
    }
}

