/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;

public class ResultSetMetadataImpl
implements ResultSetMetadata {
    private final List<ColumnMetadata> columns;
    @IgniteToStringExclude
    private final Object2IntMap<String> columnsIndices;

    public ResultSetMetadataImpl(List<ColumnMetadata> columns) {
        this.columns = Collections.unmodifiableList(columns);
        this.columnsIndices = new Object2IntOpenHashMap(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            ColumnMetadata column = columns.get(i);
            this.columnsIndices.put((Object)column.name(), i);
        }
    }

    public List<ColumnMetadata> columns() {
        return this.columns;
    }

    public int indexOf(String columnName) {
        return this.columnsIndices.getOrDefault((Object)columnName, -1);
    }

    public String toString() {
        return S.toString(ResultSetMetadataImpl.class, (Object)this);
    }
}

