/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdSelectivity;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.ignite.internal.sql.engine.prepare.bounds.ExactBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.MultiBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.RangeBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class IgniteMdSelectivity
extends RelMdSelectivity {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.SELECTIVITY.method, (MetadataHandler)new IgniteMdSelectivity());

    public Double getSelectivity(AbstractIndexScan rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return this.getSelectivity((ProjectableFilterableTableScan)rel, mq, predicate);
        }
        List<SearchBounds> searchBounds = rel.searchBounds();
        if (CollectionUtils.nullOrEmpty(searchBounds)) {
            return RelMdUtil.guessSelectivity((RexNode)rel.condition());
        }
        double idxSelectivity = 1.0;
        List conjunctions = RelOptUtil.conjunctions((RexNode)rel.condition());
        for (SearchBounds bounds : searchBounds) {
            if (bounds != null) {
                conjunctions.remove(bounds.condition());
            }
            idxSelectivity *= IgniteMdSelectivity.guessCostMultiplier(bounds);
        }
        RexNode remaining = RexUtil.composeConjunction((RexBuilder)RexUtils.builder((RelNode)rel), (Iterable)conjunctions, (boolean)true);
        return idxSelectivity * RelMdUtil.guessSelectivity((RexNode)remaining);
    }

    public Double getSelectivity(ProjectableFilterableTableScan rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate == null) {
            return RelMdUtil.guessSelectivity((RexNode)rel.condition());
        }
        RexNode condition = rel.pushUpPredicate();
        if (condition == null) {
            return RelMdUtil.guessSelectivity((RexNode)predicate);
        }
        RexNode diff = RelMdUtil.minusPreds((RexBuilder)RexUtils.builder((RelNode)rel), (RexNode)predicate, (RexNode)condition);
        return RelMdUtil.guessSelectivity((RexNode)diff);
    }

    public Double getSelectivity(IgniteSortedIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }

    public Double getSelectivity(IgniteHashIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }

    private static double guessCostMultiplier(SearchBounds bounds) {
        if (bounds instanceof ExactBounds) {
            return 0.1;
        }
        if (bounds instanceof RangeBounds) {
            RangeBounds rangeBounds = (RangeBounds)bounds;
            if (rangeBounds.condition() != null) {
                return ((RexCall)rangeBounds.condition()).op.kind == SqlKind.EQUALS ? 0.1 : 0.2;
            }
            return 0.35;
        }
        if (bounds instanceof MultiBounds) {
            MultiBounds multiBounds = (MultiBounds)bounds;
            return multiBounds.bounds().stream().mapToDouble(IgniteMdSelectivity::guessCostMultiplier).max().orElseThrow(AssertionError::new);
        }
        return 1.0;
    }
}

