/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DefaultValueDefinition;

public class ColumnDefinition {
    private final String name;
    private final RelDataType type;
    private final DefaultValueDefinition defaultValueDefinition;

    public ColumnDefinition(String name, RelDataType type, DefaultValueDefinition defaultValueDefinition) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.defaultValueDefinition = Objects.requireNonNull(defaultValueDefinition, "defaultValueDefinition");
    }

    public String name() {
        return this.name;
    }

    public RelDataType type() {
        return this.type;
    }

    public <T extends DefaultValueDefinition> T defaultValueDefinition() {
        return (T)this.defaultValueDefinition;
    }

    public boolean nullable() {
        return this.type.isNullable();
    }

    public Integer precision() {
        return this.type.getPrecision() != -1 ? Integer.valueOf(this.type.getPrecision()) : null;
    }

    public Integer scale() {
        return this.type.getScale() != Integer.MIN_VALUE ? Integer.valueOf(this.type.getScale()) : null;
    }
}

