/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteSingleSortAggregate;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.HintUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class SortAggregateConverterRule {
    public static final RelOptRule SINGLE = new SortSingleAggregateConverterRule();
    public static final RelOptRule MAP_REDUCE = new SortMapReduceAggregateConverterRule();

    private SortAggregateConverterRule() {
    }

    private static class SortMapReduceAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        SortMapReduceAggregateConverterRule() {
            super(LogicalAggregate.class, "SortMapReduceAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (CollectionUtils.nullOrEmpty((Iterable)agg.getGroupSet()) || agg.getGroupSets().size() > 1) {
                return null;
            }
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelNode input = agg.getInput();
            RelCollation collation = TraitUtils.createCollation(agg.getGroupSet().asList());
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation);
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation);
            IgniteMapSortAggregate map = new IgniteMapSortAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.random()), SortMapReduceAggregateConverterRule.convert((RelNode)input, (RelTraitSet)inTrait), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList(), collation);
            return new IgniteReduceSortAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), SortMapReduceAggregateConverterRule.convert((RelNode)map, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList(), agg.getRowType(), collation);
        }
    }

    private static class SortSingleAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        SortSingleAggregateConverterRule() {
            super(LogicalAggregate.class, "SortSingleAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (CollectionUtils.nullOrEmpty((Iterable)agg.getGroupSet()) || agg.getGroupSets().size() > 1) {
                return null;
            }
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelNode input = agg.getInput();
            RelCollation collation = TraitUtils.createCollation(agg.getGroupSet().asList());
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation).replace((RelTrait)IgniteDistributions.single());
            return new IgniteSingleSortAggregate(cluster, outTrait, SortSingleAggregateConverterRule.convert((RelNode)input, (RelTraitSet)inTrait), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }
    }
}

