/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.DefaultValueStrategy;

public class ColumnDescriptorImpl
implements ColumnDescriptor {
    private static final Supplier<Object> NULL_SUPPLIER = () -> null;
    private final boolean nullable;
    private final boolean key;
    private final String name;
    private final Supplier<Object> dfltVal;
    private final DefaultValueStrategy defaultStrategy;
    private final int logicalIndex;
    private final int physicalIndex;
    private final NativeType storageType;

    public ColumnDescriptorImpl(String name, boolean key, boolean nullable, int logicalIndex, int physicalIndex, NativeType type, DefaultValueStrategy defaultStrategy, Supplier<Object> dfltVal) {
        this.key = key;
        this.nullable = nullable;
        this.name = name;
        this.defaultStrategy = defaultStrategy;
        this.logicalIndex = logicalIndex;
        this.physicalIndex = physicalIndex;
        this.storageType = type;
        this.dfltVal = defaultStrategy != DefaultValueStrategy.DEFAULT_NULL ? Objects.requireNonNull(dfltVal, "dfltVal") : NULL_SUPPLIER;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public boolean key() {
        return this.key;
    }

    @Override
    public DefaultValueStrategy defaultStrategy() {
        return this.defaultStrategy;
    }

    @Override
    public Object defaultValue() {
        return this.dfltVal.get();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int logicalIndex() {
        return this.logicalIndex;
    }

    @Override
    public int physicalIndex() {
        return this.physicalIndex;
    }

    @Override
    public NativeType physicalType() {
        return this.storageType;
    }
}

