/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.stream.ChunkedInput;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.direct.DirectMessageWriter;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.OutNetworkObject;
import org.apache.ignite.network.serialization.MessageSerializer;
import org.apache.ignite.network.serialization.MessageWriter;

public class OutboundEncoder
extends MessageToMessageEncoder<OutNetworkObject> {
    public static final String NAME = "outbound-encoder";
    private static final NetworkMessagesFactory MSG_FACTORY = new NetworkMessagesFactory();
    private final PerSessionSerializationService serializationService;

    public OutboundEncoder(PerSessionSerializationService serializationService) {
        this.serializationService = serializationService;
    }

    protected void encode(ChannelHandlerContext ctx, OutNetworkObject msg, List<Object> out) throws Exception {
        out.add(new NetworkMessageChunkedInput(msg, this.serializationService));
    }

    private static class NetworkMessageChunkedInput
    implements ChunkedInput<ByteBuf> {
        private final NetworkMessage msg;
        private final MessageSerializer<NetworkMessage> serializer;
        private final MessageSerializer<ClassDescriptorListMessage> descriptorSerializer;
        private final DirectMessageWriter writer;
        private final ClassDescriptorListMessage descriptors;
        private final PerSessionSerializationService serializationService;
        private boolean finished = false;
        private boolean descriptorsFinished = false;

        private NetworkMessageChunkedInput(OutNetworkObject outObject, PerSessionSerializationService serializationService) {
            this.serializationService = serializationService;
            this.msg = outObject.networkMessage();
            if (!outObject.descriptors().isEmpty()) {
                List<ClassDescriptorMessage> descriptors = outObject.descriptors();
                descriptors = descriptors.stream().filter(classDescriptorMessage -> !serializationService.isDescriptorSent(classDescriptorMessage.descriptorId())).collect(Collectors.toList());
                this.descriptors = MSG_FACTORY.classDescriptorListMessage().messages(descriptors).build();
                short groupType = this.descriptors.groupType();
                short messageType = this.descriptors.messageType();
                this.descriptorSerializer = serializationService.createMessageSerializer(groupType, messageType);
            } else {
                this.descriptors = null;
                this.descriptorSerializer = null;
                this.descriptorsFinished = true;
            }
            this.serializer = serializationService.createMessageSerializer(this.msg.groupType(), this.msg.messageType());
            this.writer = new DirectMessageWriter(serializationService, 1);
        }

        public boolean isEndOfInput() throws Exception {
            return this.finished;
        }

        public void close() throws Exception {
        }

        @Deprecated
        public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
            ByteBuf buffer = allocator.ioBuffer();
            int capacity = buffer.capacity();
            ByteBuffer byteBuffer = buffer.internalNioBuffer(0, capacity);
            int initialPosition = byteBuffer.position();
            this.writer.setBuffer(byteBuffer);
            while (byteBuffer.hasRemaining()) {
                if (!this.descriptorsFinished) {
                    this.descriptorsFinished = this.descriptorSerializer.writeMessage((NetworkMessage)this.descriptors, (MessageWriter)this.writer);
                    if (!this.descriptorsFinished) break;
                    for (ClassDescriptorMessage classDescriptorMessage : this.descriptors.messages()) {
                        this.serializationService.addSentDescriptor(classDescriptorMessage.descriptorId());
                    }
                    this.writer.reset();
                    continue;
                }
                this.finished = this.serializer.writeMessage(this.msg, (MessageWriter)this.writer);
                break;
            }
            buffer.writerIndex(byteBuffer.position() - initialPosition);
            return buffer;
        }

        public long length() {
            return -1L;
        }

        public long progress() {
            return 0L;
        }
    }
}

