/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.jraft.rpc.ActionRequest;
import org.apache.ignite.raft.jraft.rpc.ActionRequestBuilder;

public class ActionRequestImpl
implements ActionRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 4000;
    @IgniteToStringInclude
    private Command command;
    private byte[] commandByteArray;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final boolean readOnlySafe;

    private ActionRequestImpl(Command command, byte[] commandByteArray, String groupId, boolean readOnlySafe) {
        this.command = command;
        this.commandByteArray = commandByteArray;
        this.groupId = groupId;
        this.readOnlySafe = readOnlySafe;
    }

    byte[] commandByteArray() {
        return this.commandByteArray;
    }

    @Override
    public Command command() {
        return this.command;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public boolean readOnlySafe() {
        return this.readOnlySafe;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ActionRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 4000;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ActionRequestImpl otherMessage = (ActionRequestImpl)other;
        return Objects.equals(this.command, otherMessage.command) && Objects.equals(this.groupId, otherMessage.groupId) && this.readOnlySafe == otherMessage.readOnlySafe;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.readOnlySafe, this.command, this.groupId);
        return result;
    }

    public static ActionRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject commandByteArraymo = marshaller.marshal((Object)this.command);
        usedDescriptors.addAll((IntCollection)commandByteArraymo.usedDescriptorIds());
        this.commandByteArray = commandByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.command = (Command)marshaller.unmarshal(this.commandByteArray, descriptorsObj);
        this.commandByteArray = null;
    }

    private static class Builder
    implements ActionRequestBuilder {
        private Command command;
        private byte[] commandByteArray;
        private String groupId;
        private boolean readOnlySafe;

        private Builder() {
        }

        @Override
        public ActionRequestBuilder command(Command command) {
            this.command = command;
            return this;
        }

        @Override
        public ActionRequestBuilder commandByteArray(byte[] commandByteArray) {
            this.commandByteArray = commandByteArray;
            return this;
        }

        @Override
        public ActionRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public ActionRequestBuilder readOnlySafe(boolean readOnlySafe) {
            this.readOnlySafe = readOnlySafe;
            return this;
        }

        @Override
        public Command command() {
            return this.command;
        }

        @Override
        public byte[] commandByteArray() {
            return this.commandByteArray;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public boolean readOnlySafe() {
            return this.readOnlySafe;
        }

        @Override
        public ActionRequest build() {
            return new ActionRequestImpl(this.command, this.commandByteArray, this.groupId, this.readOnlySafe);
        }
    }
}

