/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.constants;

public enum HttpCode {
    OK(200, "OK"),
    BAD_REQUEST(400, "Bad Request"),
    NOT_FOUND(404, "Not Found"),
    INTERNAL_ERROR(500, "Internal Server Error");

    private final int code;
    private final String message;

    private HttpCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public static HttpCode valueOf(int code) {
        switch (code) {
            case 200: {
                return OK;
            }
            case 400: {
                return BAD_REQUEST;
            }
            case 404: {
                return NOT_FOUND;
            }
            case 500: {
                return INTERNAL_ERROR;
            }
        }
        throw new IllegalArgumentException(code + " is unknown http code");
    }
}

