/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.schema;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.marshaller.schema.SchemaSerializer;

public abstract class AbstractSchemaSerializer
implements SchemaSerializer {
    protected final short version;
    protected final AbstractSchemaSerializer previous;

    protected AbstractSchemaSerializer(short ver, AbstractSchemaSerializer previous) {
        this.version = ver;
        this.previous = previous;
    }

    protected AbstractSchemaSerializer(short ver) {
        this(ver, null);
    }

    public short getVersion() {
        return this.version;
    }

    public byte[] serialize(SchemaDescriptor desc) {
        ByteBuffer buf = ByteBuffer.allocate(this.size(desc));
        this.writeTo(desc, buf);
        return buf.array();
    }

    public SchemaDescriptor deserialize(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        short ver = this.readVersion(buf);
        return this.getSerializerByVersion(ver).readFrom(buf);
    }

    private SchemaSerializer getSerializerByVersion(short ver) {
        if (ver == this.version) {
            return this;
        }
        if (this.previous == null) {
            throw new IllegalArgumentException("Unable to find schema serializer with version " + ver);
        }
        return this.previous.getSerializerByVersion(ver);
    }

    private short readVersion(ByteBuffer buf) {
        return buf.getShort();
    }
}

