/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.row;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.TemporalNativeType;
import org.apache.ignite.internal.schema.row.InternalTuple;
import org.apache.ignite.internal.schema.row.TemporalTypesHelper;
import org.apache.ignite.internal.schema.row.VarTableFormat;
import org.apache.ignite.internal.util.ColocationUtils;
import org.apache.ignite.internal.util.HashCalculator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Row
implements BinaryRowEx,
SchemaAware,
InternalTuple {
    private static final int NULLMAP_CHUNK_OFFSET = 5;
    protected final SchemaDescriptor schema;
    private final BinaryRow row;
    private final ByteBuffer keySlice;
    private final ByteBuffer valueSlice;
    private int colocationHash;

    public Row(SchemaDescriptor schema, BinaryRow row) {
        this.row = row;
        this.schema = schema;
        this.keySlice = row.keySlice();
        this.valueSlice = row.valueSlice();
    }

    @Override
    @NotNull
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean hasValue() {
        return this.row.hasValue();
    }

    @Override
    public int count() {
        return this.schema.length();
    }

    public Object value(int col) {
        return this.schema.column(col).type().spec().objectValue(this, col);
    }

    @Override
    public byte byteValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT8, isKeyCol);
        return off < 0L ? (byte)0 : this.chunk(isKeyCol).get(Row.offset(off));
    }

    @Override
    public Byte byteValueBoxed(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT8, isKeyCol);
        return off < 0L ? null : Byte.valueOf(this.chunk(isKeyCol).get(Row.offset(off)));
    }

    @Override
    public short shortValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT16, isKeyCol);
        return off < 0L ? (short)0 : this.chunk(isKeyCol).getShort(Row.offset(off));
    }

    @Override
    public Short shortValueBoxed(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT16, isKeyCol);
        return off < 0L ? null : Short.valueOf(this.chunk(isKeyCol).getShort(Row.offset(off)));
    }

    @Override
    public int intValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT32, isKeyCol);
        return off < 0L ? 0 : this.chunk(isKeyCol).getInt(Row.offset(off));
    }

    @Override
    public Integer intValueBoxed(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT32, isKeyCol);
        return off < 0L ? null : Integer.valueOf(this.chunk(isKeyCol).getInt(Row.offset(off)));
    }

    @Override
    public long longValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT64, isKeyCol);
        return off < 0L ? 0L : this.chunk(isKeyCol).getLong(Row.offset(off));
    }

    @Override
    public Long longValueBoxed(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.INT64, isKeyCol);
        return off < 0L ? null : Long.valueOf(this.chunk(isKeyCol).getLong(Row.offset(off)));
    }

    @Override
    public float floatValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.FLOAT, isKeyCol);
        return off < 0L ? 0.0f : this.chunk(isKeyCol).getFloat(Row.offset(off));
    }

    @Override
    public Float floatValueBoxed(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.FLOAT, isKeyCol);
        return off < 0L ? null : Float.valueOf(this.chunk(isKeyCol).getFloat(Row.offset(off)));
    }

    @Override
    public double doubleValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.DOUBLE, isKeyCol);
        return off < 0L ? 0.0 : this.chunk(isKeyCol).getDouble(Row.offset(off));
    }

    @Override
    public Double doubleValueBoxed(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long off = this.findColumn(col, NativeTypeSpec.DOUBLE, isKeyCol);
        return off < 0L ? null : Double.valueOf(this.chunk(isKeyCol).getDouble(Row.offset(off)));
    }

    @Override
    public BigDecimal decimalValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.DECIMAL, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        int len = Row.length(offLen);
        DecimalNativeType type = (DecimalNativeType)this.schema.column(col).type();
        byte[] bytes = this.readBytes(this.chunk(isKeyCol), off, len);
        return new BigDecimal(new BigInteger(bytes), type.scale());
    }

    @Override
    public BigInteger numberValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.NUMBER, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        int len = Row.length(offLen);
        return new BigInteger(this.readBytes(this.chunk(isKeyCol), off, len));
    }

    @Override
    public String stringValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.STRING, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        int len = Row.length(offLen);
        ByteBuffer chunk = this.chunk(isKeyCol);
        if (chunk.hasArray()) {
            return new String(chunk.array(), chunk.arrayOffset() + off, len, StandardCharsets.UTF_8);
        }
        return new String(this.readBytes(chunk, off, len), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] bytesValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.BYTES, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        int len = Row.length(offLen);
        return this.readBytes(this.chunk(isKeyCol), off, len);
    }

    @Override
    public UUID uuidValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long found = this.findColumn(col, NativeTypeSpec.UUID, isKeyCol);
        if (found < 0L) {
            return null;
        }
        int off = Row.offset(found);
        ByteBuffer chunk = this.chunk(isKeyCol);
        long lsb = chunk.getLong(off);
        long msb = chunk.getLong(off + 8);
        return new UUID(msb, lsb);
    }

    @Override
    public BitSet bitmaskValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.BITMASK, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        int len = this.columnLength(col);
        return BitSet.valueOf(this.readBytes(this.chunk(isKeyCol), off, len));
    }

    @Override
    public LocalDate dateValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.DATE, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        return this.readDate(this.chunk(isKeyCol), off);
    }

    @Override
    public LocalTime timeValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.TIME, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        TemporalNativeType type = (TemporalNativeType)this.schema.column(col).type();
        return this.readTime(this.chunk(isKeyCol), off, type);
    }

    @Override
    public LocalDateTime dateTimeValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.DATETIME, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        TemporalNativeType type = (TemporalNativeType)this.schema.column(col).type();
        ByteBuffer chunk = this.chunk(isKeyCol);
        return LocalDateTime.of(this.readDate(chunk, off), this.readTime(chunk, off + 3, type));
    }

    @Override
    public Instant timestampValue(int col) throws InvalidTypeException {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        long offLen = this.findColumn(col, NativeTypeSpec.TIMESTAMP, isKeyCol);
        if (offLen < 0L) {
            return null;
        }
        int off = Row.offset(offLen);
        TemporalNativeType type = (TemporalNativeType)this.schema.column(col).type();
        ByteBuffer chunk = this.chunk(isKeyCol);
        long seconds = chunk.getLong(off);
        int nanos = 0;
        if (type.precision() != 0) {
            nanos = chunk.getInt(off + 8);
        }
        return Instant.ofEpochSecond(seconds, nanos);
    }

    @Override
    public boolean hasNullValue(int col) {
        return this.hasNullValue(col, null);
    }

    public boolean hasNullValue(int col, @Nullable NativeTypeSpec expectedType) {
        boolean isKeyCol = this.schema.isKeyColumn(col);
        return this.findColumn(col, expectedType, isKeyCol) < 0L;
    }

    private LocalTime readTime(ByteBuffer chunk, int off, TemporalNativeType type) {
        long time = Integer.toUnsignedLong(chunk.getInt(off));
        if (type.precision() > 3) {
            time <<= 16;
            time |= Short.toUnsignedLong(chunk.getShort(off + 4));
            time = time >>> 30 << 32 | time & 0x3FFFFFFFL;
        } else {
            time = time >>> 14 << 32 | time & 0x3FFFL;
        }
        return TemporalTypesHelper.decodeTime(type, time);
    }

    private LocalDate readDate(ByteBuffer chunk, int off) {
        int date = Short.toUnsignedInt(chunk.getShort(off)) << 8;
        return TemporalTypesHelper.decodeDate(date |= Byte.toUnsignedInt(chunk.get(off + 2)));
    }

    protected long findColumn(int colIdx, NativeTypeSpec type, boolean isKeyCol) throws InvalidTypeException {
        Columns cols;
        ByteBuffer chunk = this.chunk(isKeyCol);
        byte flags = chunk.get(4);
        if (isKeyCol) {
            cols = this.schema.keyColumns();
        } else {
            if (!this.hasValue()) {
                throw new IllegalStateException("Row has no value.");
            }
            colIdx -= this.schema.keyColumns().length();
            cols = this.schema.valueColumns();
        }
        NativeTypeSpec actualType = cols.column(colIdx).type().spec();
        if (type != null && actualType != type) {
            throw new InvalidTypeException("Invalid column type requested [requested=" + type + ", column=" + cols.column(colIdx) + "]");
        }
        int nullMapLen = cols.nullMapSize();
        VarTableFormat format = VarTableFormat.fromFlags(flags);
        if (nullMapLen > 0 && this.isNull(chunk, colIdx)) {
            return -1L;
        }
        int dataOffset = this.varTableOffset(nullMapLen);
        dataOffset += format.vartableLength(format.readVartableSize(chunk, dataOffset));
        return actualType.fixedLength() ? (long)this.fixedSizeColumnOffset(chunk, dataOffset, cols, colIdx, nullMapLen > 0) : this.varlenColumnOffsetAndLength(chunk, dataOffset, cols, colIdx, nullMapLen, format);
    }

    int fixedSizeColumnOffset(ByteBuffer chunk, int dataOffset, Columns cols, int idx, boolean hasNullmap) {
        int colOff = 0;
        int colByteIdx = idx >> 3;
        int startBit = idx & 7;
        int endBit = colByteIdx == cols.length() + 7 >> 2 ? cols.numberOfFixsizeColumns() - 1 & 7 : 7;
        int mask = 255 >> 7 - endBit & 255 << startBit;
        if (hasNullmap) {
            for (int i = 0; i < colByteIdx; ++i) {
                colOff += cols.foldFixedLength(i, Byte.toUnsignedInt(chunk.get(5 + i)));
            }
            colOff += cols.foldFixedLength(colByteIdx, Byte.toUnsignedInt(chunk.get(5 + colByteIdx)) | mask);
        } else {
            for (int i = 0; i < colByteIdx; ++i) {
                colOff += cols.foldFixedLength(i, 0);
            }
            colOff += cols.foldFixedLength(colByteIdx, mask);
        }
        return dataOffset + colOff;
    }

    long varlenColumnOffsetAndLength(ByteBuffer chunk, int dataOff, Columns cols, int idx, int nullMapLen, VarTableFormat format) {
        assert (cols.hasVarlengthColumns() && cols.firstVarlengthColumn() <= idx) : "Invalid varlen column index: colId=" + idx;
        if (nullMapLen > 0) {
            int nullStartByte = cols.firstVarlengthColumn() >> 3;
            int startBitInByte = cols.firstVarlengthColumn() & 7;
            int nullEndByte = idx >> 3;
            int endBitInByte = idx & 7;
            int numNullsBefore = 0;
            for (int i = nullStartByte; i <= nullEndByte; ++i) {
                byte nullmapByte = chunk.get(5 + i);
                if (i == nullStartByte) {
                    nullmapByte = (byte)(nullmapByte & 255 << startBitInByte);
                }
                if (i == nullEndByte) {
                    nullmapByte = (byte)(nullmapByte & 255 >> 8 - endBitInByte);
                }
                numNullsBefore += Columns.numberOfNullColumns(nullmapByte);
            }
            idx -= numNullsBefore;
        }
        if ((idx -= cols.numberOfFixsizeColumns()) == 0) {
            int off = cols.numberOfFixsizeColumns() == 0 ? dataOff : this.fixedSizeColumnOffset(chunk, dataOff, cols, cols.numberOfFixsizeColumns(), nullMapLen > 0);
            long len = format != VarTableFormat.SKIPPED ? (long)(dataOff + format.readVarlenOffset(chunk, this.varTableOffset(nullMapLen), 0) - off) : (long)(chunk.limit() - off);
            return len << 32 | (long)off;
        }
        int varTblOff = this.varTableOffset(nullMapLen);
        int vartblSize = format.readVartableSize(chunk, varTblOff);
        assert (idx > 0 && vartblSize >= idx) : "Vartable index is out of bound: colId=" + idx;
        int resOff = dataOff + format.readVarlenOffset(chunk, varTblOff, idx - 1);
        long len = vartblSize == idx ? (long)(chunk.limit() - resOff) : (long)(dataOff + format.readVarlenOffset(chunk, varTblOff, idx) - resOff);
        return len << 32 | (long)resOff;
    }

    private ByteBuffer chunk(boolean isKeyCol) {
        return isKeyCol ? this.keySlice : this.valueSlice;
    }

    private int varTableOffset(int nullMapLen) {
        return 5 + nullMapLen;
    }

    protected boolean isNull(ByteBuffer chunk, int idx) {
        int nullByte = idx >> 3;
        int posInByte = idx & 7;
        int map = chunk.get(5 + nullByte) & 0xFF;
        return (map & 1 << posInByte) != 0;
    }

    private int columnLength(int colIdx) {
        Column col = this.schema.column(colIdx);
        return col.type().sizeInBytes();
    }

    private static int offset(long offLen) {
        return (int)offLen;
    }

    private static int length(long offLen) {
        return (int)(offLen >>> 32);
    }

    @Override
    public int schemaVersion() {
        return this.row.schemaVersion();
    }

    @Override
    public int hash() {
        return this.row.hash();
    }

    @Override
    public ByteBuffer keySlice() {
        return this.row.keySlice();
    }

    @Override
    public ByteBuffer valueSlice() {
        return this.row.valueSlice();
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        this.row.writeTo(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(ByteBuffer chunk, int off, int len) {
        try {
            byte[] res = new byte[len];
            chunk.position(off);
            chunk.get(res, 0, res.length);
            byte[] byArray = res;
            return byArray;
        }
        finally {
            chunk.position(0);
        }
    }

    @Override
    public byte[] bytes() {
        return this.row.bytes();
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.row.byteBuffer();
    }

    @Override
    public int colocationHash() {
        int h0 = this.colocationHash;
        if (h0 == 0) {
            HashCalculator hashCalc = new HashCalculator();
            for (Column c : this.schema().colocationColumns()) {
                ColocationUtils.append(hashCalc, this.value(c.schemaIndex()), c.type().spec());
            }
            this.colocationHash = h0 = hashCalc.hash();
        }
        return h0;
    }
}

