/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.tree.IgniteTree;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.jetbrains.annotations.Nullable;

class AbortWriteInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    private final AbstractPageMemoryMvPartitionStorage storage;
    private IgniteTree.OperationType operationType;
    @Nullable
    private VersionChain newRow;
    @Nullable
    private RowVersion toRemove;
    @Nullable
    private BinaryRow previousUncommittedRowVersion;

    AbortWriteInvokeClosure(RowId rowId, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.storage = storage;
    }

    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        if (oldRow == null || oldRow.transactionId() == null) {
            this.operationType = IgniteTree.OperationType.NOOP;
            return;
        }
        RowVersion latestVersion = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
        assert (latestVersion.isUncommitted());
        this.toRemove = latestVersion;
        if (latestVersion.hasNextLink()) {
            RowVersion nextVersion = this.storage.readRowVersion(latestVersion.nextLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
            this.newRow = VersionChain.createCommitted(this.rowId, latestVersion.nextLink(), nextVersion.nextLink());
            this.operationType = IgniteTree.OperationType.PUT;
        } else {
            this.operationType = IgniteTree.OperationType.REMOVE;
        }
        this.previousUncommittedRowVersion = latestVersion.value();
    }

    @Nullable
    public VersionChain newRow() {
        assert (this.operationType != IgniteTree.OperationType.PUT ? this.newRow == null : this.newRow != null) : "newRow=" + String.valueOf(this.newRow) + ", op=" + String.valueOf(this.operationType);
        return this.newRow;
    }

    public IgniteTree.OperationType operationType() {
        assert (this.operationType != null);
        return this.operationType;
    }

    @Nullable
    BinaryRow getPreviousUncommittedRowVersion() {
        return this.previousUncommittedRowVersion;
    }

    void afterCompletion() {
        assert (this.operationType != IgniteTree.OperationType.NOOP ? this.toRemove != null : this.toRemove == null) : "toRemove=" + String.valueOf(this.toRemove) + ", op=" + String.valueOf(this.operationType);
        if (this.toRemove != null) {
            this.storage.removeRowVersion(this.toRemove);
        }
    }
}

