/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryPart;
import org.apache.ignite.internal.catalog.sql.QueryUtils;

class ColumnTypeImpl<T>
extends QueryPart {
    private final ColumnType<T> wrapped;

    public static <T> ColumnTypeImpl<T> wrap(ColumnType<T> type) {
        return new ColumnTypeImpl<T>(type);
    }

    private ColumnTypeImpl(ColumnType<T> type) {
        this.wrapped = type;
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql(this.wrapped.typeName());
        if (QueryUtils.isGreaterThanZero(this.wrapped.length())) {
            ctx.sql("(").sql(this.wrapped.length()).sql(")");
        } else if (QueryUtils.isGreaterThanZero(this.wrapped.precision())) {
            ctx.sql("(").sql(this.wrapped.precision());
            if (QueryUtils.isGreaterThanZero(this.wrapped.scale())) {
                ctx.sql(", ").sql(this.wrapped.scale());
            }
            ctx.sql(")");
        }
        if (this.wrapped.nullable() != null && !this.wrapped.nullable().booleanValue()) {
            ctx.sql(" NOT NULL");
        }
        if (this.wrapped.defaultValue() != null) {
            if (ColumnTypeImpl.isNeedsQuotes(this.wrapped)) {
                ctx.sql(" DEFAULT '").sql(this.wrapped.defaultValue().toString()).sql("'");
            } else {
                ctx.sql(" DEFAULT ").sql(this.wrapped.defaultValue().toString());
            }
        } else if (this.wrapped.defaultExpression() != null) {
            ctx.sql(" DEFAULT ").sql(this.wrapped.defaultExpression());
        }
    }

    private static boolean isNeedsQuotes(ColumnType<?> type) {
        Class typeClass = type.type();
        return String.class.equals((Object)typeClass) || Date.class.equals((Object)typeClass) || Time.class.equals((Object)typeClass) || Timestamp.class.equals((Object)typeClass) || byte[].class.equals((Object)typeClass) || UUID.class.equals((Object)typeClass);
    }
}

