/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.ExplicitReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class TableFunctionReturnTypeInference
extends ExplicitReturnTypeInference {
    private final List<String> paramNames;
    private @MonotonicNonNull Set<RelColumnMapping> columnMappings;
    private final boolean isPassthrough;

    public TableFunctionReturnTypeInference(RelProtoDataType unexpandedOutputType, List<String> paramNames, boolean isPassthrough) {
        super(unexpandedOutputType);
        this.paramNames = paramNames;
        this.isPassthrough = isPassthrough;
    }

    public @Nullable Set<RelColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        this.columnMappings = new HashSet<RelColumnMapping>();
        RelDataType unexpandedOutputType = (RelDataType)this.protoType.apply(opBinding.getTypeFactory());
        ArrayList<RelDataType> expandedOutputTypes = new ArrayList<RelDataType>();
        ArrayList<String> expandedFieldNames = new ArrayList<String>();
        for (RelDataTypeField field : unexpandedOutputType.getFieldList()) {
            RelDataType fieldType = field.getType();
            String fieldName = field.getName();
            if (fieldType.getSqlTypeName() != SqlTypeName.CURSOR) {
                expandedOutputTypes.add(fieldType);
                expandedFieldNames.add(fieldName);
                continue;
            }
            int paramOrdinal = -1;
            int iCursor = 0;
            for (int i = 0; i < this.paramNames.size(); ++i) {
                if (this.paramNames.get(i).equals(fieldName)) {
                    paramOrdinal = i;
                    break;
                }
                RelDataType cursorType = opBinding.getCursorOperand(i);
                if (cursorType == null) continue;
                ++iCursor;
            }
            assert (paramOrdinal != -1);
            boolean isRowOp = false;
            ArrayList<String> columnNames = new ArrayList<String>();
            RelDataType cursorType = opBinding.getCursorOperand(paramOrdinal);
            if (cursorType == null) {
                isRowOp = true;
                String parentCursorName = opBinding.getColumnListParamInfo(paramOrdinal, fieldName, columnNames);
                if (parentCursorName == null) {
                    throw new AssertionError();
                }
                paramOrdinal = -1;
                iCursor = 0;
                for (int i = 0; i < this.paramNames.size(); ++i) {
                    if (this.paramNames.get(i).equals(parentCursorName)) {
                        paramOrdinal = i;
                        break;
                    }
                    cursorType = opBinding.getCursorOperand(i);
                    if (cursorType == null) continue;
                    ++iCursor;
                }
                if ((cursorType = opBinding.getCursorOperand(paramOrdinal)) == null) {
                    throw new AssertionError();
                }
            }
            if (isRowOp) {
                for (String columnName : columnNames) {
                    int iInputColumn = -1;
                    RelDataTypeField cursorField = null;
                    List<RelDataTypeField> cursorTypeFieldList = cursorType.getFieldList();
                    for (RelDataTypeField cField : cursorTypeFieldList) {
                        ++iInputColumn;
                        if (!cField.getName().equals(columnName)) continue;
                        cursorField = cField;
                        break;
                    }
                    this.addOutputColumn(expandedFieldNames, expandedOutputTypes, iInputColumn, iCursor, opBinding, Objects.requireNonNull(cursorField, () -> "cursorField is not found in " + cursorTypeFieldList));
                }
                continue;
            }
            int iInputColumn = -1;
            for (RelDataTypeField cursorField : cursorType.getFieldList()) {
                this.addOutputColumn(expandedFieldNames, expandedOutputTypes, ++iInputColumn, iCursor, opBinding, cursorField);
            }
        }
        return opBinding.getTypeFactory().createStructType(expandedOutputTypes, expandedFieldNames);
    }

    @RequiresNonNull(value={"columnMappings"})
    private void addOutputColumn(List<String> expandedFieldNames, List<RelDataType> expandedOutputTypes, int iInputColumn, int iCursor, SqlOperatorBinding opBinding, RelDataTypeField cursorField) {
        SqlCallBinding sqlCallBinding;
        this.columnMappings.add(new RelColumnMapping(expandedFieldNames.size(), iCursor, iInputColumn, !this.isPassthrough));
        boolean nullable = true;
        if (opBinding instanceof SqlCallBinding && (sqlCallBinding = (SqlCallBinding)opBinding).getValidator().isSystemField(cursorField)) {
            nullable = false;
        }
        RelDataType nullableType = opBinding.getTypeFactory().createTypeWithNullability(cursorField.getType(), nullable);
        for (String fieldName : expandedFieldNames) {
            if (!fieldName.equals(cursorField.getName())) continue;
            throw opBinding.newError(Static.RESOURCE.duplicateColumnName(cursorField.getName()));
        }
        expandedOutputTypes.add(nullableType);
        expandedFieldNames.add(cursorField.getName());
    }
}

