/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerSchema;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.marshaller.TupleReader;
import org.apache.ignite.internal.marshaller.ValidationUtils;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.DataStreamer;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.KeyValuePojoStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.MarshallerException;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.lang.UnexpectedNullValueException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class KeyValueViewImpl<K, V>
extends AbstractTableView<Map.Entry<K, V>>
implements KeyValueView<K, V> {
    private final Mapper<K> keyMapper;
    private final Mapper<V> valueMapper;
    private final Function<SchemaDescriptor, KvMarshaller<K, V>> marshallerFactory;
    @Nullable
    private volatile KvMarshaller<K, V> marsh;

    public KeyValueViewImpl(InternalTable tbl, SchemaRegistry schemaRegistry, SchemaVersions schemaVersions, IgniteSql sql, MarshallersProvider marshallers, Mapper<K> keyMapper, Mapper<V> valueMapper) {
        super(tbl, schemaVersions, schemaRegistry, sql, marshallers);
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.marshallerFactory = schema -> new KvMarshallerImpl(schema, marshallers, keyMapper, valueMapper);
    }

    public V get(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return (V)ViewUtils.sync(this.doGet(tx, key, "getNullable"));
    }

    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGet(tx, key, "getNullableAsync");
    }

    private CompletableFuture<V> doGet(@Nullable Transaction tx, K key, String altMethod) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod));
        });
    }

    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullable");
        return (NullableValue)ViewUtils.sync(this.doGetNullable(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullableAsync");
        return this.doGetNullable(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullable(@Nullable Transaction tx, K key) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    public V getOrDefault(@Nullable Transaction tx, K key, V defaultValue) {
        return (V)ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, V defaultValue) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(r -> IgniteUtils.nonNullOrElse(this.unmarshalNullableValue((BinaryRow)r, schemaVersion), (Object)defaultValue));
        });
    }

    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return (Map)ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(keys, schemaVersion);
            return this.tbl.getAll(rows, (InternalTransaction)tx).thenApply(resultRows -> this.unmarshalPairs((Collection<BinaryRow>)resultRows, schemaVersion));
        });
    }

    public boolean contains(@Nullable Transaction tx, K key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(Objects::nonNull);
        });
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> keyRows = this.marshal(keys, schemaVersion);
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                for (BinaryRow row : rows) {
                    if (row != null) continue;
                    return false;
                }
                return true;
            });
        });
    }

    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        ViewUtils.sync(this.putAsync(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.upsert(row, (InternalTransaction)tx);
        });
    }

    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        for (Map.Entry<K, V> entry : pairs.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            Objects.requireNonNull(key, "key");
            ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        }
        return this.doOperation(tx, schemaVersion -> {
            List<BinaryRowEx> rows = this.marshalPairs(pairs.entrySet(), schemaVersion, null);
            return this.tbl.upsertAll(rows, (InternalTransaction)tx);
        });
    }

    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return (V)ViewUtils.sync(this.doGetAndPut(tx, key, val, "getNullableAndPut"));
    }

    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return this.doGetAndPut(tx, key, val, "getNullableAndPutAsync");
    }

    private CompletableFuture<V> doGetAndPut(@Nullable Transaction tx, K key, @Nullable V val, String altMethod) {
        return this.doOperation(tx, schemaVersion -> this.tbl.getAndUpsert(this.marshal(key, val, schemaVersion), (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod)));
    }

    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullableAndPut");
        return (NullableValue)ViewUtils.sync(this.doGetNullableAndPut(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullableAndPutAsync");
        return this.doGetNullableAndPut(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.getAndUpsert(row, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        return (Boolean)ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.insert(row, (InternalTransaction)tx);
        });
    }

    public boolean remove(@Nullable Transaction tx, K key) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, K key, @Nullable V val) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, schemaVersion);
            return this.tbl.delete(row, (InternalTransaction)tx);
        });
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.deleteExact(row, (InternalTransaction)tx);
        });
    }

    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return (Collection)ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(keys, schemaVersion);
            return this.tbl.deleteAll(rows, (InternalTransaction)tx).thenApply(resultRows -> this.unmarshalKeys((Collection<BinaryRow>)resultRows, schemaVersion));
        });
    }

    public V getAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return (V)ViewUtils.sync(this.doGetAndRemove(tx, key, "getNullableAndRemove"));
    }

    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGetAndRemove(tx, key, "getNullableAndRemoveAsync");
    }

    private CompletableFuture<V> doGetAndRemove(@Nullable Transaction tx, K key, String altMethod) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.getAndDelete(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod));
        });
    }

    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullableAndRemove");
        return (NullableValue)ViewUtils.sync(this.doGetNullableAndRemove(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullableAndRemoveAsync");
        return this.doGetNullableAndRemove(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.getAndDelete(keyRow, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.replace(row, (InternalTransaction)tx);
        });
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(oldVal, (Class)this.valueMapper.targetType());
        ValidationUtils.validateNullableValue(newVal, (Class)this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx oldRow = this.marshal(key, oldVal, schemaVersion);
            BinaryRowEx newRow = this.marshal(key, newVal, schemaVersion);
            return this.tbl.replace(oldRow, newRow, (InternalTransaction)tx);
        });
    }

    public V getAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return (V)ViewUtils.sync(this.doGetAndReplace(tx, key, val, "getNullableAndReplace"));
    }

    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valueMapper.targetType());
        return this.doGetAndReplace(tx, key, val, "getNullableAndReplaceAsync");
    }

    private CompletableFuture<V> doGetAndReplace(@Nullable Transaction tx, K key, @Nullable V val, String altMethod) {
        return this.doOperation(tx, schemaVersion -> this.tbl.getAndReplace(this.marshal(key, val, schemaVersion), (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod)));
    }

    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullableAndReplace");
        return (NullableValue)ViewUtils.sync(this.doGetNullableAndReplace(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valueMapper.targetType(), (String)"getNullableAndReplaceAsync");
        return this.doGetNullableAndReplace(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.getAndReplace(row, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    private KvMarshaller<K, V> marshaller(int schemaVersion) {
        KvMarshaller<K, V> marsh = this.marsh;
        if (marsh != null && marsh.schemaVersion() == schemaVersion) {
            return marsh;
        }
        try {
            SchemaRegistry registry = this.rowConverter.registry();
            this.marsh = marsh = this.marshallerFactory.apply(registry.schema(schemaVersion));
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
        return marsh;
    }

    private BinaryRowEx marshal(K key, int schemaVersion) {
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        return marsh.marshal(key);
    }

    private BinaryRowEx marshal(K key, @Nullable V val, int schemaVersion) {
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        return marsh.marshal(key, val);
    }

    private Collection<BinaryRowEx> marshal(Collection<K> keys, int schemaVersion) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(keys.size());
        for (K key : keys) {
            keyRows.add((BinaryRowEx)marsh.marshal(Objects.requireNonNull(key)));
        }
        return keyRows;
    }

    private List<BinaryRowEx> marshalPairs(Collection<Map.Entry<K, V>> pairs, int schemaVersion, @Nullable BitSet deleted) {
        if (pairs.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(pairs.size());
        for (Map.Entry<K, V> pair : pairs) {
            boolean isDeleted = deleted != null && deleted.get(rows.size());
            K key = Objects.requireNonNull(pair.getKey());
            Row row = isDeleted ? marsh.marshal(key) : marsh.marshal(key, pair.getValue());
            rows.add((BinaryRowEx)row);
        }
        return rows;
    }

    private Collection<K> unmarshalKeys(Collection<BinaryRow> rows, int schemaVersion) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        ArrayList<Object> keys = new ArrayList<Object>(rows.size());
        for (Row row : this.rowConverter.resolveKeys(rows, schemaVersion)) {
            if (row == null) continue;
            keys.add(marsh.unmarshalKeyOnly(row));
        }
        return keys;
    }

    @Nullable
    private V unmarshalNullableValue(@Nullable BinaryRow binaryRow, int schemaVersion) {
        if (binaryRow == null) {
            return null;
        }
        Row row = this.rowConverter.resolveRow(binaryRow, schemaVersion);
        KvMarshaller<K, V> marshaller = this.marshaller(row.schemaVersion());
        return (V)marshaller.unmarshalValue(row);
    }

    private Map<K, V> unmarshalPairs(Collection<BinaryRow> rows, int schemaVersion) {
        if (rows.isEmpty()) {
            return Collections.emptyMap();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        HashMap pairs = IgniteUtils.newHashMap((int)rows.size());
        for (Row row : this.rowConverter.resolveRows(rows, schemaVersion)) {
            if (row == null) continue;
            pairs.put(marsh.unmarshalKey(row), marsh.unmarshalValue(row));
        }
        return pairs;
    }

    @Nullable
    private V unmarshalValue(@Nullable BinaryRow binaryRow, int schemaVersion, String altMethod) {
        if (binaryRow == null) {
            return null;
        }
        V v = this.unmarshalNullableValue(binaryRow, schemaVersion);
        if (v == null) {
            throw new UnexpectedNullValueException(IgniteStringFormatter.format((String)"Got unexpected null value: use `{}` sibling method instead.", (Object[])new Object[]{altMethod}));
        }
        return v;
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher, "publisher");
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.withSchemaSync(null, schemaVersion -> this.tbl.updateAll((Collection<BinaryRowEx>)this.marshalPairs(items, schemaVersion, deleted), deleted, (int)partitionId)));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, options, batchSender, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    public <E, V1, R, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, Map.Entry<K, V>> keyFunc, Function<E, V1> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options, @Nullable A receiverArg) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        StreamerBatchSender batchSender = (partitionId, rows, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.tbl.partitionLocation(new TablePartitionId(this.tbl.tableId(), partitionId.intValue())).thenCompose(node -> this.tbl.streamerReceiverRunner().runReceiverAsync(receiver, receiverArg, rows, (ClusterNode)node, receiver.units())));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options, batchSender, resultSubscriber, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    private KeyValuePojoStreamerPartitionAwarenessProvider<K, V> streamerPartitioner() {
        return new KeyValuePojoStreamerPartitionAwarenessProvider<K, V>(this.rowConverter.registry(), this.tbl.partitions(), this.marshaller(this.rowConverter.registry().lastKnownSchemaVersion()));
    }

    @Override
    protected Function<SqlRow, Map.Entry<K, V>> queryMapper(ResultSetMetadata meta, SchemaDescriptor schema) {
        List keyCols = schema.keyColumns();
        List valCols = schema.valueColumns();
        MarshallerSchema marshallerSchema = schema.marshallerSchema();
        Marshaller keyMarsh = this.marshallers.getKeysMarshaller(marshallerSchema, this.keyMapper, false, true);
        Marshaller valMarsh = this.marshallers.getValuesMarshaller(marshallerSchema, this.valueMapper, false, true);
        return row -> new IgniteBiTuple(keyMarsh.readObject((MarshallerReader)new TupleReader((Tuple)new SqlRowProjection(row, meta, KeyValueViewImpl.columnNames(keyCols))), null), valMarsh.readObject((MarshallerReader)new TupleReader((Tuple)new SqlRowProjection(row, meta, KeyValueViewImpl.columnNames(valCols))), null));
    }
}

