/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.jetbrains.annotations.Nullable;

public class CatalogSchemaDescriptor
extends CatalogObjectDescriptor {
    public static final CatalogObjectSerializer<CatalogSchemaDescriptor> SERIALIZER = new SchemaDescriptorSerializer();
    private final CatalogTableDescriptor[] tables;
    private final CatalogIndexDescriptor[] indexes;
    private final CatalogSystemViewDescriptor[] systemViews;
    @IgniteToStringExclude
    private Map<String, CatalogTableDescriptor> tablesMap;
    @IgniteToStringExclude
    private Map<String, CatalogIndexDescriptor> indexesMap;
    @IgniteToStringExclude
    private Map<String, CatalogSystemViewDescriptor> systemViewsMap;

    public CatalogSchemaDescriptor(int id, String name, CatalogTableDescriptor[] tables, CatalogIndexDescriptor[] indexes, CatalogSystemViewDescriptor[] systemViews, long causalityToken) {
        super(id, CatalogObjectDescriptor.Type.SCHEMA, name, causalityToken);
        this.tables = Objects.requireNonNull(tables, "tables");
        this.indexes = Objects.requireNonNull(indexes, "indexes");
        this.systemViews = Objects.requireNonNull(systemViews, "systemViews");
        this.rebuildMaps();
    }

    public CatalogTableDescriptor[] tables() {
        return this.tables;
    }

    public CatalogIndexDescriptor[] indexes() {
        return this.indexes;
    }

    public CatalogSystemViewDescriptor[] systemViews() {
        return this.systemViews;
    }

    @Nullable
    public CatalogTableDescriptor table(String name) {
        return this.tablesMap.get(name);
    }

    @Nullable
    public CatalogIndexDescriptor aliveIndex(String name) {
        return this.indexesMap.get(name);
    }

    @Nullable
    public CatalogSystemViewDescriptor systemView(String name) {
        return this.systemViewsMap.get(name);
    }

    public boolean isEmpty() {
        return this.tables.length == 0 && this.indexes.length == 0 && this.systemViews.length == 0;
    }

    private void rebuildMaps() {
        this.tablesMap = Arrays.stream(this.tables).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.indexesMap = Arrays.stream(this.indexes).filter(index -> index.status().isAlive()).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.systemViewsMap = Arrays.stream(this.systemViews).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
    }

    @Override
    public String toString() {
        return S.toString(CatalogSchemaDescriptor.class, (Object)this, (String)super.toString());
    }

    private static class SchemaDescriptorSerializer
    implements CatalogObjectSerializer<CatalogSchemaDescriptor> {
        private SchemaDescriptorSerializer() {
        }

        @Override
        public CatalogSchemaDescriptor readFrom(IgniteDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateToken = input.readVarInt();
            CatalogTableDescriptor[] tables = CatalogSerializationUtils.readArray(CatalogTableDescriptor.SERIALIZER, input, CatalogTableDescriptor.class);
            CatalogIndexDescriptor[] indexes = CatalogSerializationUtils.readArray(CatalogSerializationUtils.IDX_SERIALIZER, input, CatalogIndexDescriptor.class);
            CatalogSystemViewDescriptor[] systemViews = CatalogSerializationUtils.readArray(CatalogSystemViewDescriptor.SERIALIZER, input, CatalogSystemViewDescriptor.class);
            return new CatalogSchemaDescriptor(id, name, tables, indexes, systemViews, updateToken);
        }

        @Override
        public void writeTo(CatalogSchemaDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateToken());
            CatalogSerializationUtils.writeArray(descriptor.tables(), CatalogTableDescriptor.SERIALIZER, output);
            CatalogSerializationUtils.writeArray(descriptor.indexes(), CatalogSerializationUtils.IDX_SERIALIZER, output);
            CatalogSerializationUtils.writeArray(descriptor.systemViews(), CatalogSystemViewDescriptor.SERIALIZER, output);
        }
    }
}

