/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class ColumnFamily {
    private final RocksDB db;
    private final String cfName;
    private final byte[] cfNameBytes;
    private final ColumnFamilyHandle cfHandle;
    @Nullable
    private final ColumnFamilyOptions privateCfOptions;

    private ColumnFamily(RocksDB db, ColumnFamilyHandle handle, @Nullable ColumnFamilyOptions privateCfOptions) throws RocksDBException {
        this.db = db;
        this.cfHandle = handle;
        this.cfNameBytes = this.cfHandle.getName();
        this.cfName = new String(this.cfNameBytes, StandardCharsets.UTF_8);
        this.privateCfOptions = privateCfOptions;
    }

    public static ColumnFamily withPrivateOptions(RocksDB db, ColumnFamilyDescriptor descriptor) throws RocksDBException {
        ColumnFamilyHandle cfHandle = db.createColumnFamily(descriptor);
        return new ColumnFamily(db, cfHandle, descriptor.getOptions());
    }

    public static ColumnFamily wrap(RocksDB db, ColumnFamilyHandle handle) throws RocksDBException {
        return new ColumnFamily(db, handle, null);
    }

    public void destroy() throws RocksDBException {
        this.db.dropColumnFamily(this.cfHandle);
        this.db.destroyColumnFamilyHandle(this.cfHandle);
        if (this.privateCfOptions != null) {
            this.privateCfOptions.close();
        }
    }

    public byte @Nullable [] get(byte[] key) throws RocksDBException {
        return this.db.get(this.cfHandle, key);
    }

    public void put(byte[] key, byte[] value) throws RocksDBException {
        this.db.put(this.cfHandle, key, value);
    }

    public void put(WriteOptions writeOptions, byte[] key, byte[] value) throws RocksDBException {
        this.db.put(this.cfHandle, writeOptions, key, value);
    }

    public void put(WriteBatch batch, byte[] key, byte[] value) throws RocksDBException {
        batch.put(this.cfHandle, key, value);
    }

    public void delete(byte[] key) throws RocksDBException {
        this.db.delete(this.cfHandle, key);
    }

    public void delete(WriteBatch batch, byte[] key) throws RocksDBException {
        batch.delete(this.cfHandle, key);
    }

    public void deleteRange(byte[] start, byte[] end) throws RocksDBException {
        this.db.deleteRange(this.cfHandle, start, end);
    }

    public RocksIterator newIterator() {
        return this.db.newIterator(this.cfHandle);
    }

    public RocksIterator newIterator(ReadOptions options) {
        return this.db.newIterator(this.cfHandle, options);
    }

    public void ingestExternalFile(List<String> paths, IngestExternalFileOptions options) throws RocksDBException {
        this.db.ingestExternalFile(this.cfHandle, paths, options);
    }

    public ColumnFamilyHandle handle() {
        return this.cfHandle;
    }

    @Nullable
    public ColumnFamilyOptions privateOptions() {
        return this.privateCfOptions;
    }

    public String name() {
        return this.cfName;
    }

    public byte[] nameBytes() {
        return this.cfNameBytes;
    }

    public RocksDB db() {
        return this.db;
    }
}

