/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.network;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.network.CmgMessageCallback;
import org.apache.ignite.internal.cluster.management.network.messages.CancelInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.ClusterStateMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class CmgMessageHandler
implements NetworkMessageHandler {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterManagementGroupManager.class);
    private final IgniteSpinBusyLock busyLock;
    private final CmgMessagesFactory msgFactory;
    private final ClusterService clusterService;
    private final CmgMessageCallback cmgMessageCallback;
    @Nullable
    private List<NetworkMessageContext> messageQueue = new ArrayList<NetworkMessageContext>();
    private final Object messageQueueMux = new Object();

    public CmgMessageHandler(IgniteSpinBusyLock busyLock, CmgMessagesFactory msgFactory, ClusterService clusterService, CmgMessageCallback cmgMessageCallback) {
        this.busyLock = busyLock;
        this.msgFactory = msgFactory;
        this.clusterService = clusterService;
        this.cmgMessageCallback = cmgMessageCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onReceived(NetworkMessage message, ClusterNode sender, @Nullable Long correlationId) {
        if (!this.busyLock.enterBusy()) {
            if (correlationId == null) return;
            this.clusterService.messagingService().respond(sender, this.initFailed((Exception)new NodeStoppingException()), correlationId.longValue());
            return;
        }
        try {
            Object object = this.messageQueueMux;
            // MONITORENTER : object
            if (this.messageQueue != null) {
                this.messageQueue.add(new NetworkMessageContext(message, sender, correlationId));
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object
            if (message instanceof ClusterStateMessage) {
                this.cmgMessageCallback.onClusterStateMessageReceived((ClusterStateMessage)message, sender, correlationId);
                return;
            }
            if (message instanceof CancelInitMessage) {
                this.cmgMessageCallback.onCancelInitMessageReceived((CancelInitMessage)message, sender, correlationId);
                return;
            }
            if (!(message instanceof CmgInitMessage)) return;
            this.cmgMessageCallback.onCmgInitMessageReceived((CmgInitMessage)message, sender, correlationId);
            return;
        }
        catch (Exception e) {
            LOG.error("CMG message handling failed", (Throwable)e);
            if (correlationId == null) return;
            this.clusterService.messagingService().respond(sender, this.initFailed(e), correlationId.longValue());
            return;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRecoveryComplete() {
        Object object = this.messageQueueMux;
        synchronized (object) {
            assert (this.messageQueue != null);
            List<NetworkMessageContext> localQueue = this.messageQueue;
            this.messageQueue = null;
            for (NetworkMessageContext messageContext : localQueue) {
                this.onReceived(messageContext.message, messageContext.sender, messageContext.correlationId);
            }
        }
    }

    private NetworkMessage initFailed(Exception e) {
        return this.msgFactory.initErrorMessage().cause(e.getMessage()).build();
    }

    private static class NetworkMessageContext {
        final NetworkMessage message;
        final ClusterNode sender;
        @Nullable
        final Long correlationId;

        NetworkMessageContext(NetworkMessage message, ClusterNode sender, @Nullable Long correlationId) {
            this.message = message;
            this.sender = sender;
            this.correlationId = correlationId;
        }
    }
}

