/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class CheckpointPages {
    private final Set<FullPageId> pageIds;
    private final CheckpointProgressImpl checkpointProgress;

    public CheckpointPages(Set<FullPageId> pageIds, CheckpointProgress checkpointProgress) {
        this.pageIds = pageIds;
        this.checkpointProgress = (CheckpointProgressImpl)checkpointProgress;
    }

    public boolean removeOnPageReplacement(FullPageId pageId) throws IgniteInternalCheckedException {
        try {
            IgniteUtils.getUninterruptibly(this.checkpointProgress.futureFor(CheckpointState.PAGES_SORTED));
        }
        catch (ExecutionException e) {
            throw new IgniteInternalCheckedException(e.getCause());
        }
        catch (CancellationException e) {
            throw new IgniteInternalCheckedException((Throwable)e);
        }
        return this.pageIds.remove(pageId);
    }

    public boolean removeOnCheckpoint(FullPageId pageId) {
        return this.pageIds.remove(pageId);
    }

    public boolean contains(FullPageId pageId) {
        return this.pageIds.contains(pageId);
    }

    public int size() {
        return this.pageIds.size();
    }

    public void blockFsyncOnPageReplacement(FullPageId pageId) {
        this.checkpointProgress.blockFsyncOnPageReplacement(pageId);
    }

    public void unblockFsyncOnPageReplacement(FullPageId pageId, @Nullable Throwable error) {
        this.checkpointProgress.unblockFsyncOnPageReplacement(pageId, error);
    }

    public void blockPartitionDestruction(GroupPartitionId groupPartitionId) {
        this.checkpointProgress.blockPartitionDestruction(groupPartitionId);
    }

    public void unblockPartitionDestruction(GroupPartitionId groupPartitionId) {
        this.checkpointProgress.unblockPartitionDestruction(groupPartitionId);
    }
}

