/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.storage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgnitePentaFunction;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteTriFunction;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.network.UnresolvableConsistentIdException;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.MultipleRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.MultipleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultiRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultiRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.partition.replicator.network.replication.ScanCloseReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.SingleRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.SingleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.SwapRowReplicaRequest;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.exception.ReplicationException;
import org.apache.ignite.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.replicator.message.TimestampAware;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.StreamerReceiverRunner;
import org.apache.ignite.internal.table.distributed.TableUtils;
import org.apache.ignite.internal.table.distributed.storage.PartitionScanPublisher;
import org.apache.ignite.internal.table.distributed.storage.RowBatch;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.utils.PrimaryReplica;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class InternalTableImpl
implements InternalTable {
    public static final int AWAIT_PRIMARY_REPLICA_TIMEOUT = 30;
    private static final ReadWriteInflightBatchRequestTracker READ_WRITE_INFLIGHT_BATCH_REQUEST_TRACKER = new ReadWriteInflightBatchRequestTracker();
    private static final PartitionReplicationMessagesFactory TABLE_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final int partitions;
    private final Supplier<ScheduledExecutorService> streamerFlushExecutor;
    private final StreamerReceiverRunner streamerReceiverRunner;
    private volatile String tableName;
    private final int tableId;
    private final ClusterNodeResolver clusterNodeResolver;
    protected final TxManager txManager;
    private final TransactionInflights transactionInflights;
    private final MvTableStorage tableStorage;
    private final TxStateTableStorage txStateStorage;
    private final ReplicaService replicaSvc;
    private final Object updatePartitionMapsMux = new Object();
    private final ClockService clockService;
    private final HybridTimestampTracker observableTimestampTracker;
    private final PlacementDriver placementDriver;
    private volatile Int2ObjectMap<PendingComparableValuesTracker<HybridTimestamp, Void>> safeTimeTrackerByPartitionId = Int2ObjectMaps.emptyMap();
    private volatile Int2ObjectMap<PendingComparableValuesTracker<Long, Void>> storageIndexTrackerByPartitionId = Int2ObjectMaps.emptyMap();
    private final long implicitTransactionTimeout;
    private final int attemptsObtainLock;

    public InternalTableImpl(String tableName, int tableId, int partitions, ClusterNodeResolver clusterNodeResolver, TxManager txManager, MvTableStorage tableStorage, TxStateTableStorage txStateStorage, ReplicaService replicaSvc, ClockService clockService, HybridTimestampTracker observableTimestampTracker, PlacementDriver placementDriver, TransactionInflights transactionInflights, long implicitTransactionTimeout, int attemptsObtainLock, Supplier<ScheduledExecutorService> streamerFlushExecutor, StreamerReceiverRunner streamerReceiverRunner) {
        this.tableName = tableName;
        this.tableId = tableId;
        this.partitions = partitions;
        this.clusterNodeResolver = clusterNodeResolver;
        this.txManager = txManager;
        this.tableStorage = tableStorage;
        this.txStateStorage = txStateStorage;
        this.replicaSvc = replicaSvc;
        this.clockService = clockService;
        this.observableTimestampTracker = observableTimestampTracker;
        this.placementDriver = placementDriver;
        this.transactionInflights = transactionInflights;
        this.implicitTransactionTimeout = implicitTransactionTimeout;
        this.attemptsObtainLock = attemptsObtainLock;
        this.streamerFlushExecutor = streamerFlushExecutor;
        this.streamerReceiverRunner = streamerReceiverRunner;
    }

    @Override
    public MvTableStorage storage() {
        return this.tableStorage;
    }

    @Override
    public int partitions() {
        return this.partitions;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public String name() {
        return this.tableName;
    }

    @Override
    public void name(String newName) {
        this.tableName = newName;
    }

    private <R> CompletableFuture<R> enlistInTx(BinaryRowEx row, @Nullable InternalTransaction tx, IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest> fac, BiPredicate<R, ReplicaRequest> noWriteChecker) {
        return this.enlistInTx(row, tx, fac, noWriteChecker, null);
    }

    private <R> CompletableFuture<R> enlistInTx(BinaryRowEx row, @Nullable InternalTransaction tx, IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest> fac, BiPredicate<R, ReplicaRequest> noWriteChecker, @Nullable Long txStartTs) {
        CompletableFuture<R> fut;
        int partId;
        TablePartitionId partGroupId;
        if (tx != null && tx.isReadOnly()) {
            return CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_FAILED_READ_WRITE_OPERATION_ERR, "Failed to enlist read-write operation into read-only transaction txId={" + String.valueOf(tx.id()) + "}"));
        }
        InternalTransaction actualTx = this.startImplicitRwTxIfNeeded(tx);
        IgniteBiTuple primaryReplicaAndConsistencyToken = actualTx.enlistedNodeAndConsistencyToken(partGroupId = new TablePartitionId(this.tableId, partId = this.partitionId(row)));
        if (primaryReplicaAndConsistencyToken != null) {
            assert (!actualTx.implicit());
            fut = this.trackingInvoke(actualTx, partId, enlistmentConsistencyToken -> (ReplicaRequest)fac.apply((Object)actualTx, (Object)partGroupId, enlistmentConsistencyToken), false, (IgniteBiTuple<ClusterNode, Long>)primaryReplicaAndConsistencyToken, noWriteChecker, this.attemptsObtainLock);
        } else {
            fut = this.enlistAndInvoke(actualTx, partId, enlistmentConsistencyToken -> (ReplicaRequest)fac.apply((Object)actualTx, (Object)partGroupId, enlistmentConsistencyToken), actualTx.implicit(), noWriteChecker);
        }
        return ((CompletableFuture)this.postEnlist(fut, false, actualTx, actualTx.implicit()).handle((r, e) -> {
            if (e != null) {
                if (actualTx.implicit()) {
                    long ts;
                    long l = ts = txStartTs == null ? actualTx.startTimestamp().getPhysical() : txStartTs.longValue();
                    if (InternalTableImpl.exceptionAllowsImplicitTxRetry(e) && FastTimestamps.coarseCurrentTimeMillis() - ts < this.implicitTransactionTimeout) {
                        return this.enlistInTx(row, null, fac, noWriteChecker, ts);
                    }
                }
                ExceptionUtils.sneakyThrow((Throwable)e);
            }
            return CompletableFuture.completedFuture(r);
        })).thenCompose(Function.identity());
    }

    private <T> CompletableFuture<T> enlistInTx(Collection<BinaryRowEx> keyRows, @Nullable InternalTransaction tx, IgnitePentaFunction<Collection<? extends BinaryRow>, InternalTransaction, TablePartitionId, Long, Boolean, ReplicaRequest> fac, Function<Collection<RowBatch>, CompletableFuture<T>> reducer, BiPredicate<T, ReplicaRequest> noOpChecker) {
        return this.enlistInTx(keyRows, tx, fac, reducer, noOpChecker, null);
    }

    private <T> CompletableFuture<T> enlistInTx(Collection<BinaryRowEx> keyRows, @Nullable InternalTransaction tx, IgnitePentaFunction<Collection<? extends BinaryRow>, InternalTransaction, TablePartitionId, Long, Boolean, ReplicaRequest> fac, Function<Collection<RowBatch>, CompletableFuture<T>> reducer, BiPredicate<T, ReplicaRequest> noOpChecker, @Nullable Long txStartTs) {
        if (tx != null && tx.isReadOnly()) {
            return CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_FAILED_READ_WRITE_OPERATION_ERR, "Failed to enlist read-write operation into read-only transaction txId={" + String.valueOf(tx.id()) + "}"));
        }
        InternalTransaction actualTx = this.startImplicitRwTxIfNeeded(tx);
        Int2ObjectMap<RowBatch> rowBatchByPartitionId = this.toRowBatchByPartitionId(keyRows);
        boolean singlePart = rowBatchByPartitionId.size() == 1;
        boolean full = actualTx.implicit() && singlePart;
        for (Int2ObjectMap.Entry partitionRowBatch : rowBatchByPartitionId.int2ObjectEntrySet()) {
            CompletableFuture<T> fut;
            int partitionId = partitionRowBatch.getIntKey();
            RowBatch rowBatch = (RowBatch)partitionRowBatch.getValue();
            TablePartitionId partGroupId = new TablePartitionId(this.tableId, partitionId);
            IgniteBiTuple primaryReplicaAndConsistencyToken = actualTx.enlistedNodeAndConsistencyToken(partGroupId);
            if (primaryReplicaAndConsistencyToken != null) {
                assert (!actualTx.implicit());
                fut = this.trackingInvoke(actualTx, partitionId, enlistmentConsistencyToken -> (ReplicaRequest)fac.apply(rowBatch.requestedRows, (Object)actualTx, (Object)partGroupId, enlistmentConsistencyToken, (Object)false), false, (IgniteBiTuple<ClusterNode, Long>)primaryReplicaAndConsistencyToken, noOpChecker, this.attemptsObtainLock);
            } else {
                fut = this.enlistAndInvoke(actualTx, partitionId, enlistmentConsistencyToken -> (ReplicaRequest)fac.apply(rowBatch.requestedRows, (Object)actualTx, (Object)partGroupId, enlistmentConsistencyToken, (Object)full), full, noOpChecker);
            }
            rowBatch.resultFuture = fut;
        }
        CompletableFuture<T> fut = reducer.apply((Collection<RowBatch>)rowBatchByPartitionId.values());
        return ((CompletableFuture)this.postEnlist(fut, actualTx.implicit() && !singlePart, actualTx, full).handle((r, e) -> {
            if (e != null) {
                if (actualTx.implicit()) {
                    long ts;
                    long l = ts = txStartTs == null ? actualTx.startTimestamp().getPhysical() : txStartTs.longValue();
                    if (InternalTableImpl.exceptionAllowsImplicitTxRetry(e) && FastTimestamps.coarseCurrentTimeMillis() - ts < this.implicitTransactionTimeout) {
                        return this.enlistInTx(keyRows, null, fac, reducer, noOpChecker, ts);
                    }
                }
                ExceptionUtils.sneakyThrow((Throwable)e);
            }
            return CompletableFuture.completedFuture(r);
        })).thenCompose(Function.identity());
    }

    private InternalTransaction startImplicitRwTxIfNeeded(@Nullable InternalTransaction tx) {
        return tx == null ? this.txManager.beginImplicitRw(this.observableTimestampTracker) : tx;
    }

    private InternalTransaction startImplicitRoTxIfNeeded(@Nullable InternalTransaction tx) {
        return tx == null ? this.txManager.beginImplicitRo(this.observableTimestampTracker) : tx;
    }

    private CompletableFuture<Collection<BinaryRow>> enlistCursorInTx(InternalTransaction tx, int partId, long scanId, int batchSize, @Nullable Integer indexId, @Nullable BinaryTuple exactKey, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        TablePartitionId partGroupId = new TablePartitionId(this.tableId, partId);
        IgniteBiTuple primaryReplicaAndConsistencyToken = tx.enlistedNodeAndConsistencyToken(partGroupId);
        Function<Long, ReplicaRequest> mapFunc = enlistmentConsistencyToken -> TABLE_MESSAGES_FACTORY.readWriteScanRetrieveBatchReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(partGroupId)).tableId(this.tableId).timestamp(tx.startTimestamp()).transactionId(tx.id()).scanId(scanId).indexToUse(indexId).exactKey(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)exactKey)).lowerBoundPrefix(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)lowerBound)).upperBoundPrefix(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)upperBound)).flags(flags).columnsToInclude(columnsToInclude).full(tx.implicit()).batchSize(batchSize).enlistmentConsistencyToken(enlistmentConsistencyToken).commitPartitionId(InternalTableImpl.serializeTablePartitionId(tx.commitPartition())).coordinatorId(tx.coordinatorId()).build();
        CompletableFuture fut = primaryReplicaAndConsistencyToken != null ? this.replicaSvc.invoke((ClusterNode)primaryReplicaAndConsistencyToken.get1(), mapFunc.apply((Long)primaryReplicaAndConsistencyToken.get2())) : this.enlistAndInvoke(tx, partId, mapFunc, false, null);
        return this.postEnlist(fut, false, tx, false);
    }

    @Nullable
    private static BinaryTupleMessage binaryTupleMessage(@Nullable BinaryTupleReader binaryTuple) {
        if (binaryTuple == null) {
            return null;
        }
        return TABLE_MESSAGES_FACTORY.binaryTupleMessage().tuple(binaryTuple.byteBuffer()).elementCount(binaryTuple.elementCount()).build();
    }

    private <R> CompletableFuture<R> enlistAndInvoke(InternalTransaction tx, int partId, Function<Long, ReplicaRequest> mapFunc, boolean full, @Nullable BiPredicate<R, ReplicaRequest> noWriteChecker) {
        return this.enlist(partId, tx).thenCompose(primaryReplicaAndConsistencyToken -> this.trackingInvoke(tx, partId, mapFunc, full, (IgniteBiTuple<ClusterNode, Long>)primaryReplicaAndConsistencyToken, noWriteChecker, this.attemptsObtainLock));
    }

    private <R> CompletableFuture<R> trackingInvoke(InternalTransaction tx, int partId, Function<Long, ReplicaRequest> mapFunc, boolean full, IgniteBiTuple<ClusterNode, Long> primaryReplicaAndConsistencyToken, @Nullable BiPredicate<R, ReplicaRequest> noWriteChecker, int retryOnLockConflict) {
        boolean write;
        assert (!tx.isReadOnly()) : IgniteStringFormatter.format((String)"Tracking invoke is available only for read-write transactions [tx={}].", (Object[])new Object[]{tx});
        ReplicaRequest request = mapFunc.apply((Long)primaryReplicaAndConsistencyToken.get2());
        boolean bl = write = request instanceof SingleRowReplicaRequest && ((SingleRowReplicaRequest)request).requestType() != RequestType.RW_GET || request instanceof MultipleRowReplicaRequest && ((MultipleRowReplicaRequest)request).requestType() != RequestType.RW_GET_ALL || request instanceof SingleRowPkReplicaRequest && ((SingleRowPkReplicaRequest)request).requestType() != RequestType.RW_GET || request instanceof MultipleRowPkReplicaRequest && ((MultipleRowPkReplicaRequest)request).requestType() != RequestType.RW_GET_ALL || request instanceof SwapRowReplicaRequest;
        if (full) {
            return this.replicaSvc.invokeRaw((ClusterNode)primaryReplicaAndConsistencyToken.get1(), request).handle((r, e) -> {
                boolean hasError;
                boolean bl = hasError = e != null;
                assert (hasError || r instanceof TimestampAware);
                tx.finish(!hasError, hasError ? null : ((TimestampAware)r).timestamp(), true);
                if (e != null) {
                    ExceptionUtils.sneakyThrow((Throwable)e);
                }
                return r.result();
            });
        }
        if (write) {
            if (!this.transactionInflights.addInflight(tx.id(), false)) {
                return CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is already finished [tableName={}, partId={}, txState={}].", (Object[])new Object[]{this.tableName, partId, tx.state()})));
            }
            return ((CompletableFuture)((CompletableFuture)this.replicaSvc.invoke((ClusterNode)primaryReplicaAndConsistencyToken.get1(), request).thenApply(res -> {
                assert (noWriteChecker != null);
                if (noWriteChecker.test(res, request)) {
                    this.transactionInflights.removeInflight(tx.id());
                }
                return res;
            })).handle((r, e) -> {
                if (e != null) {
                    if (retryOnLockConflict > 0 && ExceptionUtils.matchAny((Throwable)ExceptionUtils.unwrapCause((Throwable)e), (int)ErrorGroups.Transactions.ACQUIRE_LOCK_ERR, (int[])new int[0])) {
                        this.transactionInflights.removeInflight(tx.id());
                        return this.trackingInvoke(tx, partId, ignored -> request, false, primaryReplicaAndConsistencyToken, noWriteChecker, retryOnLockConflict - 1);
                    }
                    ExceptionUtils.sneakyThrow((Throwable)e);
                }
                return CompletableFuture.completedFuture(r);
            })).thenCompose(Function.identity());
        }
        return ((CompletableFuture)this.replicaSvc.invoke((ClusterNode)primaryReplicaAndConsistencyToken.get1(), request).handle((r, e) -> {
            if (e != null) {
                if (retryOnLockConflict > 0 && ExceptionUtils.matchAny((Throwable)ExceptionUtils.unwrapCause((Throwable)e), (int)ErrorGroups.Transactions.ACQUIRE_LOCK_ERR, (int[])new int[0])) {
                    return this.trackingInvoke(tx, partId, ignored -> request, false, primaryReplicaAndConsistencyToken, noWriteChecker, retryOnLockConflict - 1);
                }
                ExceptionUtils.sneakyThrow((Throwable)e);
            }
            return CompletableFuture.completedFuture(r);
        })).thenCompose(Function.identity());
    }

    private <T> CompletableFuture<T> postEnlist(CompletableFuture<T> fut, boolean autoCommit, InternalTransaction tx0, boolean full) {
        assert (!autoCommit || !full) : "Invalid combination of flags";
        return ((CompletableFuture)fut.handle((r, e) -> {
            if (full) {
                return e != null ? CompletableFuture.failedFuture(e) : CompletableFuture.completedFuture(r);
            }
            if (e != null) {
                return tx0.rollbackAsync().handle((ignored, err) -> {
                    if (err != null) {
                        e.addSuppressed((Throwable)err);
                    }
                    ExceptionUtils.sneakyThrow((Throwable)e);
                    return null;
                });
            }
            if (autoCommit) {
                return tx0.commitAsync().thenApply(ignored -> r);
            }
            return CompletableFuture.completedFuture(r);
        })).thenCompose(Function.identity());
    }

    private <R> CompletableFuture<R> evaluateReadOnlyPrimaryNode(@Nullable InternalTransaction tx, BinaryRowEx row, BiFunction<TablePartitionId, Long, ReplicaRequest> op) {
        InternalTransaction actualTx = this.startImplicitRoTxIfNeeded(tx);
        int partId = this.partitionId(row);
        TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partId);
        return this.sendReadOnlyToPrimaryReplica(actualTx, tablePartitionId, op);
    }

    private <R> CompletableFuture<R> evaluateReadOnlyPrimaryNode(@Nullable InternalTransaction tx, Collection<BinaryRowEx> rows, BiFunction<TablePartitionId, Long, ReplicaRequest> op) {
        InternalTransaction actualTx = this.startImplicitRoTxIfNeeded(tx);
        int partId = this.partitionId(rows.iterator().next());
        TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partId);
        return this.sendReadOnlyToPrimaryReplica(actualTx, tablePartitionId, op);
    }

    private <R> CompletableFuture<R> sendReadOnlyToPrimaryReplica(InternalTransaction tx, TablePartitionId tablePartitionId, BiFunction<TablePartitionId, Long, ReplicaRequest> op) {
        CompletionStage fut;
        ReplicaMeta meta = this.placementDriver.getCurrentPrimaryReplica((ReplicationGroupId)tablePartitionId, tx.startTimestamp());
        Function<ReplicaMeta, CompletableFuture> evaluateClo = primaryReplica -> {
            try {
                ClusterNode node = this.getClusterNode((ReplicaMeta)primaryReplica);
                return this.replicaSvc.invoke(node, (ReplicaRequest)op.apply(tablePartitionId, InternalTableImpl.enlistmentConsistencyToken(primaryReplica)));
            }
            catch (Throwable e) {
                throw new TransactionException(ErrorGroups.Common.INTERNAL_ERR, IgniteStringFormatter.format((String)"Failed to invoke the replica request [tableName={}, grp={}].", (Object[])new Object[]{this.tableName, tablePartitionId}), e);
            }
        };
        if (meta != null && this.clusterNodeResolver.getById(meta.getLeaseholderId()) != null) {
            try {
                fut = evaluateClo.apply(meta);
            }
            catch (IgniteException e) {
                return CompletableFuture.failedFuture(e);
            }
        } else {
            fut = this.awaitPrimaryReplica(tablePartitionId, tx.startTimestamp()).thenCompose(evaluateClo);
        }
        return this.postEvaluate((CompletableFuture<R>)fut, tx);
    }

    private <R> CompletableFuture<R> postEvaluate(CompletableFuture<R> fut, InternalTransaction tx) {
        return ((CompletableFuture)fut.handle((r, e) -> {
            if (e != null) {
                return tx.finish(false, this.clockService.current(), false).handle((ignored, err) -> {
                    if (err != null) {
                        e.addSuppressed((Throwable)err);
                    }
                    ExceptionUtils.sneakyThrow((Throwable)e);
                    return null;
                });
            }
            return tx.finish(true, this.clockService.current(), false).thenApply(ignored -> r);
        })).thenCompose(Function.identity());
    }

    @Override
    public CompletableFuture<BinaryRow> get(BinaryRowEx keyRow, @Nullable InternalTransaction tx) {
        this.checkTransactionFinishStarted(tx);
        if (TableUtils.isDirectFlowApplicableTx(tx)) {
            return this.evaluateReadOnlyPrimaryNode(tx, keyRow, (TablePartitionId groupId, Long consistencyToken) -> TABLE_MESSAGES_FACTORY.readOnlyDirectSingleRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).enlistmentConsistencyToken(consistencyToken).schemaVersion(keyRow.schemaVersion()).primaryKey(keyRow.tupleSlice()).requestType(RequestType.RO_GET).build());
        }
        if (tx.isReadOnly()) {
            return this.evaluateReadOnlyRecipientNode(this.partitionId(keyRow), tx.readTimestamp()).thenCompose(recipientNode -> this.get(keyRow, tx.readTimestamp(), tx.id(), tx.coordinatorId(), (ClusterNode)recipientNode));
        }
        return this.enlistInTx(keyRow, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowPkReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).schemaVersion(keyRow.schemaVersion()).primaryKey(keyRow.tupleSlice()).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_GET).timestamp(txo.startTimestamp()).full(false).coordinatorId(txo.coordinatorId()).build()), (res, req) -> false);
    }

    @Override
    public CompletableFuture<BinaryRow> get(BinaryRowEx keyRow, HybridTimestamp readTimestamp, @Nullable UUID transactionId, @Nullable UUID coordinatorId, ClusterNode recipientNode) {
        int partId = this.partitionId(keyRow);
        TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partId);
        return this.replicaSvc.invoke(recipientNode, (ReplicaRequest)TABLE_MESSAGES_FACTORY.readOnlySingleRowPkReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(tablePartitionId)).tableId(this.tableId).schemaVersion(keyRow.schemaVersion()).primaryKey(keyRow.tupleSlice()).requestType(RequestType.RO_GET).readTimestamp(readTimestamp).transactionId(transactionId).coordinatorId(coordinatorId).build());
    }

    private boolean isSinglePartitionBatch(Collection<BinaryRowEx> rows) {
        Iterator<BinaryRowEx> rowIterator = rows.iterator();
        int partId = this.partitionId(rowIterator.next());
        while (rowIterator.hasNext()) {
            BinaryRowEx row = rowIterator.next();
            if (partId == this.partitionId(row)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompletableFuture<List<BinaryRow>> getAll(Collection<BinaryRowEx> keyRows, InternalTransaction tx) {
        this.checkTransactionFinishStarted(tx);
        if (CollectionUtils.nullOrEmpty(keyRows)) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        if (TableUtils.isDirectFlowApplicableTx(tx) && this.isSinglePartitionBatch(keyRows)) {
            return this.evaluateReadOnlyPrimaryNode(tx, keyRows, (TablePartitionId groupId, Long consistencyToken) -> TABLE_MESSAGES_FACTORY.readOnlyDirectMultiRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).enlistmentConsistencyToken(consistencyToken).schemaVersion(((BinaryRowEx)keyRows.iterator().next()).schemaVersion()).primaryKeys(InternalTableImpl.serializeBinaryTuples(keyRows)).requestType(RequestType.RO_GET_ALL).build());
        }
        if (tx != null && tx.isReadOnly()) {
            BinaryRowEx firstRow = keyRows.iterator().next();
            return this.evaluateReadOnlyRecipientNode(this.partitionId(firstRow), tx.readTimestamp()).thenCompose(recipientNode -> this.getAll(keyRows, tx.readTimestamp(), tx.id(), tx.coordinatorId(), (ClusterNode)recipientNode));
        }
        return this.enlistInTx(keyRows, tx, (IgnitePentaFunction<Collection<? extends BinaryRow>, InternalTransaction, TablePartitionId, Long, Boolean, ReplicaRequest>)((IgnitePentaFunction)(keyRows0, txo, groupId, enlistmentConsistencyToken, full) -> this.readWriteMultiRowPkReplicaRequest(RequestType.RW_GET_ALL, (Collection<? extends BinaryRow>)keyRows0, (InternalTransaction)txo, (TablePartitionId)groupId, (Long)enlistmentConsistencyToken, (boolean)full)), InternalTableImpl::collectMultiRowsResponsesWithRestoreOrder, (T res, ReplicaRequest req) -> false);
    }

    @Override
    public CompletableFuture<List<BinaryRow>> getAll(Collection<BinaryRowEx> keyRows, HybridTimestamp readTimestamp, @Nullable UUID transactionId, @Nullable UUID coordinatorId, ClusterNode recipientNode) {
        Int2ObjectMap<RowBatch> rowBatchByPartitionId = this.toRowBatchByPartitionId(keyRows);
        for (Int2ObjectMap.Entry partitionRowBatch : rowBatchByPartitionId.int2ObjectEntrySet()) {
            TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partitionRowBatch.getIntKey());
            ReadOnlyMultiRowPkReplicaRequest request = TABLE_MESSAGES_FACTORY.readOnlyMultiRowPkReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(tablePartitionId)).tableId(this.tableId).schemaVersion(((RowBatch)partitionRowBatch.getValue()).requestedRows.get(0).schemaVersion()).primaryKeys(InternalTableImpl.serializeBinaryTuples(((RowBatch)partitionRowBatch.getValue()).requestedRows)).requestType(RequestType.RO_GET_ALL).readTimestamp(readTimestamp).transactionId(transactionId).coordinatorId(coordinatorId).build();
            ((RowBatch)partitionRowBatch.getValue()).resultFuture = this.replicaSvc.invoke(recipientNode, (ReplicaRequest)request);
        }
        return InternalTableImpl.collectMultiRowsResponsesWithRestoreOrder((Collection<RowBatch>)rowBatchByPartitionId.values());
    }

    private ReadWriteMultiRowPkReplicaRequest readWriteMultiRowPkReplicaRequest(RequestType requestType, Collection<? extends BinaryRow> rows, InternalTransaction tx, TablePartitionId groupId, Long enlistmentConsistencyToken, boolean full) {
        assert (InternalTableImpl.allSchemaVersionsSame(rows)) : "Different schema versions encountered: " + String.valueOf(InternalTableImpl.uniqueSchemaVersions(rows));
        return TABLE_MESSAGES_FACTORY.readWriteMultiRowPkReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(tx.commitPartition())).schemaVersion(rows.iterator().next().schemaVersion()).primaryKeys(InternalTableImpl.serializeBinaryTuples(rows)).transactionId(tx.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(requestType).timestamp(tx.startTimestamp()).full(full).coordinatorId(tx.coordinatorId()).build();
    }

    private static boolean allSchemaVersionsSame(Collection<? extends BinaryRow> rows) {
        int schemaVersion = -1;
        boolean first = true;
        for (BinaryRow binaryRow : rows) {
            if (binaryRow == null) continue;
            if (first) {
                schemaVersion = binaryRow.schemaVersion();
                first = false;
                continue;
            }
            if (binaryRow.schemaVersion() == schemaVersion) continue;
            return false;
        }
        return true;
    }

    private static Set<Integer> uniqueSchemaVersions(Collection<? extends BinaryRow> rows) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (BinaryRow binaryRow : rows) {
            set.add(binaryRow.schemaVersion());
        }
        return set;
    }

    private static List<ByteBuffer> serializeBinaryTuples(Collection<? extends BinaryRow> keys) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(keys.size());
        for (BinaryRow binaryRow : keys) {
            result.add(binaryRow.tupleSlice());
        }
        return result;
    }

    private static TablePartitionIdMessage serializeTablePartitionId(TablePartitionId id) {
        return ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)id);
    }

    @Override
    public CompletableFuture<Void> upsert(BinaryRowEx row, @Nullable InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(row.schemaVersion()).binaryTuple(row.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_UPSERT).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> false);
    }

    @Override
    public CompletableFuture<Void> upsertAll(Collection<BinaryRowEx> rows, @Nullable InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgnitePentaFunction<Collection<? extends BinaryRow>, InternalTransaction, TablePartitionId, Long, Boolean, ReplicaRequest>)((IgnitePentaFunction)this::upsertAllInternal), RowBatch::allResultFutures, (T res, ReplicaRequest req) -> false);
    }

    @Override
    public CompletableFuture<Void> updateAll(Collection<BinaryRowEx> rows, @Nullable BitSet deleted, int partition) {
        return this.updateAllWithRetry(rows, deleted, partition, null);
    }

    private CompletableFuture<Void> updateAllWithRetry(Collection<BinaryRowEx> rows, @Nullable BitSet deleted, int partition, @Nullable Long txStartTs) {
        InternalTransaction tx = this.txManager.beginImplicitRw(this.observableTimestampTracker);
        TablePartitionId partGroupId = new TablePartitionId(this.tableId, partition);
        assert (rows.stream().allMatch(row -> this.partitionId((BinaryRowEx)row) == partition)) : "Invalid batch for partition " + partition;
        CompletableFuture fut = this.enlistAndInvoke(tx, partition, enlistmentConsistencyToken -> this.upsertAllInternal((Collection<? extends BinaryRow>)rows, deleted, tx, partGroupId, (Long)enlistmentConsistencyToken, true), true, null);
        return ((CompletableFuture)this.postEnlist(fut, false, tx, true).handle((r, e) -> {
            if (e != null) {
                long ts;
                long l = ts = txStartTs == null ? tx.startTimestamp().getPhysical() : txStartTs.longValue();
                if (InternalTableImpl.exceptionAllowsImplicitTxRetry(e) && FastTimestamps.coarseCurrentTimeMillis() - ts < this.implicitTransactionTimeout) {
                    return this.updateAllWithRetry(rows, deleted, partition, ts);
                }
                ExceptionUtils.sneakyThrow((Throwable)e);
            }
            return CompletableFuture.completedFuture(r);
        })).thenCompose(Function.identity());
    }

    @Override
    public CompletableFuture<BinaryRow> getAndUpsert(BinaryRowEx row, InternalTransaction tx) {
        this.checkTransactionFinishStarted(tx);
        return this.enlistInTx(row, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(row.schemaVersion()).binaryTuple(row.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_GET_AND_UPSERT).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> false);
    }

    @Override
    public CompletableFuture<Boolean> insert(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(row.schemaVersion()).binaryTuple(row.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_INSERT).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> res == false);
    }

    @Override
    public CompletableFuture<List<BinaryRow>> insertAll(Collection<BinaryRowEx> rows, InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgnitePentaFunction<Collection<? extends BinaryRow>, InternalTransaction, TablePartitionId, Long, Boolean, ReplicaRequest>)((IgnitePentaFunction)(keyRows, txo, groupId, enlistmentConsistencyToken, full) -> this.readWriteMultiRowReplicaRequest(RequestType.RW_INSERT_ALL, (Collection<? extends BinaryRow>)keyRows, null, (InternalTransaction)txo, (TablePartitionId)groupId, (Long)enlistmentConsistencyToken, (boolean)full)), InternalTableImpl::collectRejectedRowsResponsesWithRestoreOrder, (T res, ReplicaRequest req) -> {
            for (BinaryRow row : res) {
                if (row == null) continue;
                return false;
            }
            return true;
        });
    }

    private ReadWriteMultiRowReplicaRequest readWriteMultiRowReplicaRequest(RequestType requestType, Collection<? extends BinaryRow> rows, @Nullable BitSet deleted, InternalTransaction tx, TablePartitionId groupId, Long enlistmentConsistencyToken, boolean full) {
        assert (InternalTableImpl.allSchemaVersionsSame(rows)) : "Different schema versions encountered: " + String.valueOf(InternalTableImpl.uniqueSchemaVersions(rows));
        return TABLE_MESSAGES_FACTORY.readWriteMultiRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(tx.commitPartition())).schemaVersion(rows.iterator().next().schemaVersion()).binaryTuples(InternalTableImpl.serializeBinaryTuples(rows)).deleted(deleted).transactionId(tx.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(requestType).timestamp(tx.startTimestamp()).full(full).coordinatorId(tx.coordinatorId()).build();
    }

    @Override
    public CompletableFuture<Boolean> replace(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(row.schemaVersion()).binaryTuple(row.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_REPLACE_IF_EXIST).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> res == false);
    }

    @Override
    public CompletableFuture<Boolean> replace(BinaryRowEx oldRow, BinaryRowEx newRow, InternalTransaction tx) {
        assert (oldRow.schemaVersion() == newRow.schemaVersion()) : "Mismatching schema versions: old " + oldRow.schemaVersion() + ", new " + newRow.schemaVersion();
        return this.enlistInTx(newRow, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSwapRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(oldRow.schemaVersion()).oldBinaryTuple(oldRow.tupleSlice()).newBinaryTuple(newRow.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_REPLACE).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> res == false);
    }

    @Override
    public CompletableFuture<BinaryRow> getAndReplace(BinaryRowEx row, InternalTransaction tx) {
        this.checkTransactionFinishStarted(tx);
        return this.enlistInTx(row, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(row.schemaVersion()).binaryTuple(row.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_GET_AND_REPLACE).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> res == null);
    }

    @Override
    public CompletableFuture<Boolean> delete(BinaryRowEx keyRow, InternalTransaction tx) {
        return this.enlistInTx(keyRow, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowPkReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(keyRow.schemaVersion()).primaryKey(keyRow.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_DELETE).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> res == false);
    }

    @Override
    public CompletableFuture<Boolean> deleteExact(BinaryRowEx oldRow, InternalTransaction tx) {
        return this.enlistInTx(oldRow, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(oldRow.schemaVersion()).binaryTuple(oldRow.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_DELETE_EXACT).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> res == false);
    }

    @Override
    public CompletableFuture<BinaryRow> getAndDelete(BinaryRowEx row, InternalTransaction tx) {
        this.checkTransactionFinishStarted(tx);
        return this.enlistInTx(row, tx, (IgniteTriFunction<InternalTransaction, TablePartitionId, Long, ReplicaRequest>)((IgniteTriFunction)(txo, groupId, enlistmentConsistencyToken) -> TABLE_MESSAGES_FACTORY.readWriteSingleRowPkReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(groupId)).tableId(this.tableId).commitPartitionId(InternalTableImpl.serializeTablePartitionId(txo.commitPartition())).schemaVersion(row.schemaVersion()).primaryKey(row.tupleSlice()).transactionId(txo.id()).enlistmentConsistencyToken(enlistmentConsistencyToken).requestType(RequestType.RW_GET_AND_DELETE).timestamp(txo.startTimestamp()).full(txo.implicit()).coordinatorId(txo.coordinatorId()).build()), (res, req) -> res == null);
    }

    @Override
    public CompletableFuture<List<BinaryRow>> deleteAll(Collection<BinaryRowEx> rows, InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgnitePentaFunction<Collection<? extends BinaryRow>, InternalTransaction, TablePartitionId, Long, Boolean, ReplicaRequest>)((IgnitePentaFunction)(keyRows0, txo, groupId, enlistmentConsistencyToken, full) -> this.readWriteMultiRowPkReplicaRequest(RequestType.RW_DELETE_ALL, (Collection<? extends BinaryRow>)keyRows0, (InternalTransaction)txo, (TablePartitionId)groupId, (Long)enlistmentConsistencyToken, (boolean)full)), InternalTableImpl::collectRejectedRowsResponsesWithRestoreOrder, (T res, ReplicaRequest req) -> {
            for (BinaryRow row : res) {
                if (row == null) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public CompletableFuture<List<BinaryRow>> deleteAllExact(Collection<BinaryRowEx> rows, InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgnitePentaFunction<Collection<? extends BinaryRow>, InternalTransaction, TablePartitionId, Long, Boolean, ReplicaRequest>)((IgnitePentaFunction)(keyRows0, txo, groupId, enlistmentConsistencyToken, full) -> this.readWriteMultiRowReplicaRequest(RequestType.RW_DELETE_EXACT_ALL, (Collection<? extends BinaryRow>)keyRows0, null, (InternalTransaction)txo, (TablePartitionId)groupId, (Long)enlistmentConsistencyToken, (boolean)full)), InternalTableImpl::collectRejectedRowsResponsesWithRestoreOrder, (T res, ReplicaRequest req) -> {
            for (BinaryRow row : res) {
                if (row == null) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public Flow.Publisher<BinaryRow> lookup(int partId, UUID txId, HybridTimestamp readTimestamp, ClusterNode recipientNode, int indexId, BinaryTuple key, @Nullable BitSet columnsToInclude, UUID txCoordinatorId) {
        return this.readOnlyScan(partId, txId, readTimestamp, recipientNode, indexId, key, null, null, 0, columnsToInclude, txCoordinatorId);
    }

    @Override
    public Flow.Publisher<BinaryRow> lookup(int partId, UUID txId, TablePartitionId commitPartition, UUID coordinatorId, PrimaryReplica recipient, int indexId, BinaryTuple key, @Nullable BitSet columnsToInclude) {
        return this.readWriteScan(partId, txId, commitPartition, coordinatorId, recipient, indexId, key, null, null, 0, columnsToInclude);
    }

    @Override
    public Flow.Publisher<BinaryRow> scan(int partId, UUID txId, HybridTimestamp readTimestamp, ClusterNode recipientNode, @Nullable Integer indexId, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude, UUID txCoordinatorId) {
        return this.readOnlyScan(partId, txId, readTimestamp, recipientNode, indexId, null, lowerBound, upperBound, flags, columnsToInclude, txCoordinatorId);
    }

    @Override
    public Flow.Publisher<BinaryRow> scan(int partId, @Nullable InternalTransaction tx, @Nullable Integer indexId, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        return this.readWriteScan(partId, tx, indexId, null, lowerBound, upperBound, flags, columnsToInclude);
    }

    @Override
    public Flow.Publisher<BinaryRow> scan(int partId, UUID txId, TablePartitionId commitPartition, UUID coordinatorId, PrimaryReplica recipient, @Nullable Integer indexId, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        return this.readWriteScan(partId, txId, commitPartition, coordinatorId, recipient, indexId, null, lowerBound, upperBound, flags, columnsToInclude);
    }

    private Flow.Publisher<BinaryRow> readOnlyScan(int partId, final UUID txId, final HybridTimestamp readTimestamp, final ClusterNode recipientNode, final @Nullable Integer indexId, final @Nullable BinaryTuple exactKey, final @Nullable BinaryTuplePrefix lowerBound, final @Nullable BinaryTuplePrefix upperBound, final int flags, final @Nullable BitSet columnsToInclude, final UUID txCoordinatorId) {
        this.validatePartitionIndex(partId);
        final TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partId);
        return new PartitionScanPublisher<BinaryRow>((PartitionScanPublisher.InflightBatchRequestTracker)new ReadOnlyInflightBatchRequestTracker(this.transactionInflights, txId)){

            @Override
            protected CompletableFuture<Collection<BinaryRow>> retrieveBatch(long scanId, int batchSize) {
                ReadOnlyScanRetrieveBatchReplicaRequest request = TABLE_MESSAGES_FACTORY.readOnlyScanRetrieveBatchReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(tablePartitionId)).tableId(InternalTableImpl.this.tableId).readTimestamp(readTimestamp).transactionId(txId).scanId(scanId).batchSize(batchSize).indexToUse(indexId).exactKey(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)exactKey)).lowerBoundPrefix(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)lowerBound)).upperBoundPrefix(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)upperBound)).flags(flags).columnsToInclude(columnsToInclude).coordinatorId(txCoordinatorId).build();
                return InternalTableImpl.this.replicaSvc.invoke(recipientNode, (ReplicaRequest)request);
            }

            @Override
            protected CompletableFuture<Void> onClose(boolean intentionallyClose, long scanId, @Nullable Throwable th) {
                return InternalTableImpl.this.completeScan(txId, tablePartitionId, scanId, th, recipientNode, intentionallyClose || th != null);
            }
        };
    }

    private Flow.Publisher<BinaryRow> readWriteScan(final int partId, final @Nullable InternalTransaction tx, final @Nullable Integer indexId, final @Nullable BinaryTuple exactKey, final @Nullable BinaryTuplePrefix lowerBound, final @Nullable BinaryTuplePrefix upperBound, final int flags, final @Nullable BitSet columnsToInclude) {
        if (tx != null && tx.isReadOnly()) {
            throw new TransactionException(ErrorGroups.Transactions.TX_FAILED_READ_WRITE_OPERATION_ERR, "Failed to enlist read-write operation into read-only transaction txId={" + String.valueOf(tx.id()) + "}");
        }
        this.validatePartitionIndex(partId);
        final InternalTransaction actualTx = this.startImplicitRwTxIfNeeded(tx);
        return new PartitionScanPublisher<BinaryRow>((PartitionScanPublisher.InflightBatchRequestTracker)READ_WRITE_INFLIGHT_BATCH_REQUEST_TRACKER){

            @Override
            protected CompletableFuture<Collection<BinaryRow>> retrieveBatch(long scanId, int batchSize) {
                return InternalTableImpl.this.enlistCursorInTx(actualTx, partId, scanId, batchSize, indexId, exactKey, lowerBound, upperBound, flags, columnsToInclude);
            }

            @Override
            protected CompletableFuture<Void> onClose(boolean intentionallyClose, long scanId, @Nullable Throwable th) {
                TablePartitionId replicationGrpId;
                CompletableFuture<Object> opFut = actualTx.implicit() ? CompletableFutures.completedOrFailedFuture(null, (Throwable)th) : (tx.enlistedNodeAndConsistencyToken(replicationGrpId = new TablePartitionId(InternalTableImpl.this.tableId, partId)) != null ? InternalTableImpl.this.completeScan(tx.id(), replicationGrpId, scanId, th, (ClusterNode)tx.enlistedNodeAndConsistencyToken(replicationGrpId).get1(), intentionallyClose) : CompletableFutures.completedOrFailedFuture(null, (Throwable)th));
                return InternalTableImpl.this.postEnlist(opFut, intentionallyClose, actualTx, actualTx.implicit() && !intentionallyClose);
            }
        };
    }

    private Flow.Publisher<BinaryRow> readWriteScan(int partId, final UUID txId, final TablePartitionId commitPartition, final UUID coordinatorId, final PrimaryReplica recipient, final @Nullable Integer indexId, final @Nullable BinaryTuple exactKey, final @Nullable BinaryTuplePrefix lowerBound, final @Nullable BinaryTuplePrefix upperBound, final int flags, final @Nullable BitSet columnsToInclude) {
        final TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partId);
        return new PartitionScanPublisher<BinaryRow>((PartitionScanPublisher.InflightBatchRequestTracker)READ_WRITE_INFLIGHT_BATCH_REQUEST_TRACKER){

            @Override
            protected CompletableFuture<Collection<BinaryRow>> retrieveBatch(long scanId, int batchSize) {
                ReadWriteScanRetrieveBatchReplicaRequest request = TABLE_MESSAGES_FACTORY.readWriteScanRetrieveBatchReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(tablePartitionId)).tableId(InternalTableImpl.this.tableId).timestamp(TransactionIds.beginTimestamp((UUID)txId)).transactionId(txId).scanId(scanId).indexToUse(indexId).exactKey(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)exactKey)).lowerBoundPrefix(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)lowerBound)).upperBoundPrefix(InternalTableImpl.binaryTupleMessage((BinaryTupleReader)upperBound)).flags(flags).columnsToInclude(columnsToInclude).batchSize(batchSize).enlistmentConsistencyToken(Long.valueOf(recipient.enlistmentConsistencyToken())).full(false).commitPartitionId(InternalTableImpl.serializeTablePartitionId(commitPartition)).coordinatorId(coordinatorId).build();
                return InternalTableImpl.this.replicaSvc.invoke(recipient.node(), (ReplicaRequest)request);
            }

            @Override
            protected CompletableFuture<Void> onClose(boolean intentionallyClose, long scanId, @Nullable Throwable th) {
                return InternalTableImpl.this.completeScan(txId, tablePartitionId, scanId, th, recipient.node(), intentionallyClose);
            }
        };
    }

    private CompletableFuture<Void> completeScan(UUID txId, TablePartitionId replicaGrpId, long scanId, Throwable th, ClusterNode recipientNode, boolean explicitCloseCursor) {
        CompletableFuture closeFut = CompletableFutures.nullCompletedFuture();
        if (explicitCloseCursor) {
            ScanCloseReplicaRequest scanCloseReplicaRequest = TABLE_MESSAGES_FACTORY.scanCloseReplicaRequest().groupId((ReplicationGroupIdMessage)InternalTableImpl.serializeTablePartitionId(replicaGrpId)).transactionId(txId).scanId(scanId).build();
            closeFut = this.replicaSvc.invoke(recipientNode, (ReplicaRequest)scanCloseReplicaRequest);
        }
        return ((CompletableFuture)closeFut.handle((unused, throwable) -> {
            CompletableFuture fut = CompletableFutures.nullCompletedFuture();
            if (th != null) {
                if (throwable != null) {
                    th.addSuppressed((Throwable)throwable);
                }
                fut = CompletableFuture.failedFuture(th);
            } else if (throwable != null) {
                fut = CompletableFuture.failedFuture(throwable);
            }
            return fut;
        })).thenCompose(Function.identity());
    }

    private void validatePartitionIndex(int p) {
        if (p < 0 || p >= this.partitions) {
            throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Invalid partition [partition={}, minValue={}, maxValue={}].", (Object[])new Object[]{p, 0, this.partitions - 1}));
        }
    }

    Int2ObjectMap<RowBatch> toRowBatchByPartitionId(Collection<BinaryRowEx> rows) {
        Int2ObjectOpenHashMap rowBatchByPartitionId = new Int2ObjectOpenHashMap();
        int i = 0;
        for (BinaryRowEx row : rows) {
            ((RowBatch)rowBatchByPartitionId.computeIfAbsent(this.partitionId(row), partitionId -> new RowBatch())).add((BinaryRow)row, i++);
        }
        return rowBatchByPartitionId;
    }

    @Override
    public TxStateTableStorage txStateStorage() {
        return this.txStateStorage;
    }

    @Override
    public int partitionId(BinaryRowEx row) {
        return IgniteUtils.safeAbs((int)row.colocationHash()) % this.partitions;
    }

    public static CompletableFuture<List<BinaryRow>> collectRejectedRowsResponsesWithRestoreOrder(Collection<RowBatch> rowBatches) {
        return InternalTableImpl.collectMultiRowsResponsesWithRestoreOrder(rowBatches, batch -> {
            ArrayList<BinaryRow> result = new ArrayList<BinaryRow>();
            List response = (List)batch.getCompletedResult();
            assert (batch.requestedRows.size() == response.size()) : "Replication response does not fit to request [requestRows=" + batch.requestedRows.size() + "responseRows=" + response.size() + "]";
            for (int i = 0; i < response.size(); ++i) {
                result.add(response.get(i) != null ? null : batch.requestedRows.get(i));
            }
            return result;
        }, true);
    }

    static CompletableFuture<List<BinaryRow>> collectMultiRowsResponsesWithRestoreOrder(Collection<RowBatch> rowBatches) {
        return InternalTableImpl.collectMultiRowsResponsesWithRestoreOrder(rowBatches, batch -> (Collection)batch.getCompletedResult(), false);
    }

    private static CompletableFuture<List<BinaryRow>> collectMultiRowsResponsesWithRestoreOrder(Collection<RowBatch> rowBatches, Function<RowBatch, Collection<BinaryRow>> bathResultMapper, boolean skipNull) {
        return RowBatch.allResultFutures(rowBatches).thenApply(response -> {
            BinaryRow[] result = new BinaryRow[RowBatch.getTotalRequestedRowSize(rowBatches)];
            for (RowBatch rowBatch : rowBatches) {
                Collection batchResult = (Collection)bathResultMapper.apply(rowBatch);
                assert (batchResult != null);
                assert (batchResult.size() == rowBatch.requestedRows.size()) : "batchResult=" + batchResult.size() + ", requestedRows=" + rowBatch.requestedRows.size();
                int i = 0;
                for (BinaryRow resultRow : batchResult) {
                    result[rowBatch.getOriginalRowIndex((int)i++)] = resultRow;
                }
            }
            ArrayList<BinaryRow> resultToReturn = new ArrayList<BinaryRow>();
            for (BinaryRow row : result) {
                if (skipNull && row == null) continue;
                resultToReturn.add(row);
            }
            return resultToReturn;
        });
    }

    protected CompletableFuture<IgniteBiTuple<ClusterNode, Long>> enlist(int partId, InternalTransaction tx) {
        HybridTimestamp now = tx.startTimestamp();
        TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partId);
        tx.assignCommitPartition(tablePartitionId);
        ReplicaMeta meta = this.placementDriver.getCurrentPrimaryReplica((ReplicationGroupId)tablePartitionId, now);
        Function<ReplicaMeta, IgniteBiTuple> enlistClo = replicaMeta -> {
            TablePartitionId partGroupId = new TablePartitionId(this.tableId, partId);
            IgniteBiTuple enlistState = new IgniteBiTuple((Object)this.getClusterNode((ReplicaMeta)replicaMeta), (Object)InternalTableImpl.enlistmentConsistencyToken(replicaMeta));
            tx.enlist(partGroupId, enlistState);
            return enlistState;
        };
        if (meta != null && this.clusterNodeResolver.getById(meta.getLeaseholderId()) != null) {
            try {
                return CompletableFuture.completedFuture(enlistClo.apply(meta));
            }
            catch (IgniteException e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        return this.partitionMeta(tablePartitionId, now).thenApply(enlistClo);
    }

    @Override
    public CompletableFuture<ClusterNode> partitionLocation(TablePartitionId tablePartitionId) {
        return this.partitionMeta(tablePartitionId, this.clockService.current()).thenApply(this::getClusterNode);
    }

    private CompletableFuture<ReplicaMeta> partitionMeta(TablePartitionId tablePartitionId, HybridTimestamp at) {
        return this.awaitPrimaryReplica(tablePartitionId, at).exceptionally(e -> {
            throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, (String)("Failed to get the primary replica [tablePartitionId=" + String.valueOf(tablePartitionId) + ", awaitTimestamp=" + String.valueOf(at) + "]"), (Throwable)e);
        });
    }

    private ClusterNode getClusterNode(ReplicaMeta replicaMeta) {
        ClusterNode node;
        UUID leaseHolderId = replicaMeta.getLeaseholderId();
        ClusterNode clusterNode = node = leaseHolderId == null ? null : this.clusterNodeResolver.getById(leaseHolderId);
        if (node == null) {
            throw new TransactionException(ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, String.format("Failed to resolve the primary replica node [id=%s]", leaseHolderId));
        }
        return node;
    }

    @Override
    public void close() {
    }

    protected CompletableFuture<ClusterNode> evaluateReadOnlyRecipientNode(int partId, @Nullable HybridTimestamp readTimestamp) {
        TablePartitionId tablePartitionId = new TablePartitionId(this.tableId, partId);
        return this.awaitPrimaryReplica(tablePartitionId, readTimestamp).handle((res, e) -> {
            if (e != null) {
                throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, (Throwable)e);
            }
            if (res == null) {
                throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, (Throwable)e);
            }
            return this.getClusterNode((ReplicaMeta)res);
        });
    }

    @Override
    @Nullable
    public PendingComparableValuesTracker<HybridTimestamp, Void> getPartitionSafeTimeTracker(int partitionId) {
        return (PendingComparableValuesTracker)this.safeTimeTrackerByPartitionId.get(partitionId);
    }

    @Override
    @Nullable
    public PendingComparableValuesTracker<Long, Void> getPartitionStorageIndexTracker(int partitionId) {
        return (PendingComparableValuesTracker)this.storageIndexTrackerByPartitionId.get(partitionId);
    }

    @Override
    public ScheduledExecutorService streamerFlushExecutor() {
        return this.streamerFlushExecutor.get();
    }

    @Override
    public CompletableFuture<Long> estimatedSize() {
        HybridTimestamp now = this.clockService.current();
        CompletableFuture[] invokeFutures = new CompletableFuture[this.partitions];
        for (int partId = 0; partId < this.partitions; ++partId) {
            TablePartitionId replicaGroupId = new TablePartitionId(this.tableId, partId);
            TablePartitionIdMessage partitionIdMessage = InternalTableImpl.serializeTablePartitionId(replicaGroupId);
            Function<ReplicaMeta, ReplicaRequest> requestFactory = replicaMeta -> TABLE_MESSAGES_FACTORY.getEstimatedSizeRequest().groupId((ReplicationGroupIdMessage)partitionIdMessage).enlistmentConsistencyToken(Long.valueOf(InternalTableImpl.enlistmentConsistencyToken(replicaMeta))).build();
            invokeFutures[partId] = this.sendToPrimaryWithRetry(replicaGroupId, now, 5, requestFactory);
        }
        return CompletableFuture.allOf(invokeFutures).thenApply(v -> Arrays.stream(invokeFutures).mapToLong(f -> (Long)f.join()).sum());
    }

    @Override
    public StreamerReceiverRunner streamerReceiverRunner() {
        return this.streamerReceiverRunner;
    }

    private <T> CompletableFuture<T> sendToPrimaryWithRetry(TablePartitionId tablePartitionId, HybridTimestamp hybridTimestamp, int numRetries, Function<ReplicaMeta, ReplicaRequest> requestFactory) {
        return ((CompletableFuture)this.awaitPrimaryReplica(tablePartitionId, hybridTimestamp).thenCompose(replicaMeta -> {
            String leaseHolderName = replicaMeta.getLeaseholder();
            assert (leaseHolderName != null);
            return this.replicaSvc.invoke(leaseHolderName, (ReplicaRequest)requestFactory.apply((ReplicaMeta)replicaMeta)).handle((response, e) -> {
                if (e == null) {
                    return CompletableFuture.completedFuture(response);
                }
                if ((e = ExceptionUtils.unwrapCause((Throwable)e)) instanceof ReplicationException && e.getCause() != null) {
                    e = e.getCause();
                }
                if (e instanceof PrimaryReplicaMissException || e instanceof UnresolvableConsistentIdException || e instanceof ReplicationTimeoutException) {
                    if (numRetries == 0) {
                        throw new IgniteException(ErrorGroups.Replicator.REPLICA_MISS_ERR, e);
                    }
                    return this.sendToPrimaryWithRetry(tablePartitionId, replicaMeta.getExpirationTime().tick(), numRetries - 1, requestFactory);
                }
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, e);
            });
        })).thenCompose(Function.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePartitionTrackers(int partitionId, PendingComparableValuesTracker<HybridTimestamp, Void> newSafeTimeTracker, PendingComparableValuesTracker<Long, Void> newStorageIndexTracker) {
        PendingComparableValuesTracker previousStorageIndexTracker;
        PendingComparableValuesTracker previousSafeTimeTracker;
        Object object = this.updatePartitionMapsMux;
        synchronized (object) {
            Int2ObjectOpenHashMap newSafeTimeTrackerMap = new Int2ObjectOpenHashMap(this.partitions);
            Int2ObjectOpenHashMap newStorageIndexTrackerMap = new Int2ObjectOpenHashMap(this.partitions);
            newSafeTimeTrackerMap.putAll(this.safeTimeTrackerByPartitionId);
            newStorageIndexTrackerMap.putAll(this.storageIndexTrackerByPartitionId);
            previousSafeTimeTracker = (PendingComparableValuesTracker)newSafeTimeTrackerMap.put(partitionId, newSafeTimeTracker);
            previousStorageIndexTracker = (PendingComparableValuesTracker)newStorageIndexTrackerMap.put(partitionId, newStorageIndexTracker);
            this.safeTimeTrackerByPartitionId = newSafeTimeTrackerMap;
            this.storageIndexTrackerByPartitionId = newStorageIndexTrackerMap;
        }
        if (previousSafeTimeTracker != null) {
            previousSafeTimeTracker.close();
        }
        if (previousStorageIndexTracker != null) {
            previousStorageIndexTracker.close();
        }
    }

    private ReplicaRequest upsertAllInternal(Collection<? extends BinaryRow> keyRows0, InternalTransaction txo, TablePartitionId groupId, Long enlistmentConsistencyToken, boolean full) {
        return this.readWriteMultiRowReplicaRequest(RequestType.RW_UPSERT_ALL, keyRows0, null, txo, groupId, enlistmentConsistencyToken, full);
    }

    private ReplicaRequest upsertAllInternal(Collection<? extends BinaryRow> keyRows0, @Nullable BitSet deleted, InternalTransaction txo, TablePartitionId groupId, Long enlistmentConsistencyToken, boolean full) {
        return this.readWriteMultiRowReplicaRequest(RequestType.RW_UPSERT_ALL, keyRows0, deleted, txo, groupId, enlistmentConsistencyToken, full);
    }

    private static boolean exceptionAllowsImplicitTxRetry(Throwable e) {
        return ExceptionUtils.matchAny((Throwable)ExceptionUtils.unwrapCause((Throwable)e), (int)ErrorGroups.Transactions.ACQUIRE_LOCK_ERR, (int[])new int[]{ErrorGroups.Replicator.REPLICA_MISS_ERR});
    }

    private CompletableFuture<ReplicaMeta> awaitPrimaryReplica(TablePartitionId tablePartitionId, HybridTimestamp timestamp) {
        return this.placementDriver.awaitPrimaryReplica((ReplicationGroupId)tablePartitionId, timestamp, 30L, TimeUnit.SECONDS);
    }

    private static long enlistmentConsistencyToken(ReplicaMeta replicaMeta) {
        return replicaMeta.getStartTime().longValue();
    }

    private void checkTransactionFinishStarted(@Nullable InternalTransaction transaction) {
        if (transaction != null && transaction.isFinishingOrFinished()) {
            throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is already finished () [txId={}, readOnly={}].", (Object[])new Object[]{transaction.id(), transaction.isReadOnly()}));
        }
    }

    private static class ReadOnlyInflightBatchRequestTracker
    implements PartitionScanPublisher.InflightBatchRequestTracker {
        private final TransactionInflights transactionInflights;
        private final UUID txId;

        ReadOnlyInflightBatchRequestTracker(TransactionInflights transactionInflights, UUID txId) {
            this.transactionInflights = transactionInflights;
            this.txId = txId;
        }

        @Override
        public void onRequestBegin() {
            if (!this.transactionInflights.addInflight(this.txId, true)) {
                throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is already finished () [txId={}, readOnly=true].", (Object[])new Object[]{this.txId}));
            }
        }

        @Override
        public void onRequestEnd() {
            this.transactionInflights.removeInflight(this.txId);
        }
    }

    private static class ReadWriteInflightBatchRequestTracker
    implements PartitionScanPublisher.InflightBatchRequestTracker {
        private ReadWriteInflightBatchRequestTracker() {
        }

        @Override
        public void onRequestBegin() {
        }

        @Override
        public void onRequestEnd() {
        }
    }
}

