/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite.internal.pagememory.io.DataPagePayload;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowImpl;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite.internal.storage.pagememory.mv.ReadRowVersionValue;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.jetbrains.annotations.Nullable;

class ReadRowVersion
implements PageMemoryTraversal<Predicate<HybridTimestamp>> {
    private final int partitionId;
    private RowVersion result;
    private boolean readingFirstSlot = true;
    private long firstFragmentLink;
    @Nullable
    private HybridTimestamp timestamp;
    private long nextLink;
    private int schemaVersion;
    private final ReadRowVersionValue readRowVersionValue = new ReadRowVersionValue();

    ReadRowVersion(int partitionId) {
        this.partitionId = partitionId;
    }

    public long consumePagePayload(long link, long pageAddr, DataPagePayload payload, Predicate<HybridTimestamp> loadValue) {
        if (this.readingFirstSlot) {
            this.readingFirstSlot = false;
            return this.readFullOrInitiateReadFragmented(link, pageAddr, payload, loadValue);
        }
        return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
    }

    private long readFullOrInitiateReadFragmented(long link, long pageAddr, DataPagePayload payload, Predicate<HybridTimestamp> loadValue) {
        this.firstFragmentLink = link;
        this.timestamp = HybridTimestamps.readTimestamp(pageAddr, payload.offset() + 1);
        this.nextLink = PartitionlessLinks.readPartitionless((int)this.partitionId, (long)pageAddr, (int)(payload.offset() + 9));
        this.schemaVersion = Short.toUnsignedInt(PageUtils.getShort((long)pageAddr, (int)(payload.offset() + 19)));
        if (!loadValue.test(this.timestamp)) {
            int valueSize = PageUtils.getInt((long)pageAddr, (int)(payload.offset() + 15));
            this.result = new RowVersion(PageIdUtils.partitionIdFromLink((long)link), this.firstFragmentLink, this.timestamp, this.nextLink, valueSize);
            return 0L;
        }
        return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
    }

    public void finish() {
        if (this.result != null) {
            return;
        }
        this.readRowVersionValue.finish();
        byte[] valueBytes = this.readRowVersionValue.result();
        BinaryRowImpl row = valueBytes.length == 0 ? null : new BinaryRowImpl(this.schemaVersion, ByteBuffer.wrap(valueBytes).order(BinaryTuple.ORDER));
        this.result = new RowVersion(PageIdUtils.partitionIdFromLink((long)this.firstFragmentLink), this.firstFragmentLink, this.timestamp, this.nextLink, (BinaryRow)row);
    }

    RowVersion result() {
        return this.result;
    }

    void reset() {
        this.result = null;
        this.readingFirstSlot = true;
        this.readRowVersionValue.reset();
    }
}

