/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.convert;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ConverterImpl
extends SingleRel
implements Converter {
    protected final RelTraitSet inTraits;
    protected final @Nullable RelTraitDef traitDef;

    protected ConverterImpl(RelOptCluster cluster, @Nullable RelTraitDef traitDef, RelTraitSet traits, RelNode child) {
        super(cluster, traits, child);
        this.inTraits = child.getTraitSet();
        this.traitDef = traitDef;
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows;
        double dCpu = dRows = mq.getRowCount(this.getInput()).doubleValue();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Deprecated
    protected Error cannotImplement() {
        return new AssertionError((Object)(this.getClass() + " cannot convert from " + this.inTraits + " traits"));
    }

    @Override
    public RelTraitSet getInputTraits() {
        return this.inTraits;
    }

    @Override
    public @Nullable RelTraitDef getTraitDef() {
        return this.traitDef;
    }
}

