/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class CatalogStorageProfileDescriptor {
    public static final CatalogObjectSerializer<CatalogStorageProfileDescriptor> SERIALIZER = new StorageProfileDescriptorSerializer();
    private final String storageProfile;

    public CatalogStorageProfileDescriptor(String storageProfile) {
        this.storageProfile = storageProfile;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public String storageProfile() {
        return this.storageProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogStorageProfileDescriptor that = (CatalogStorageProfileDescriptor)o;
        return this.storageProfile.equals(that.storageProfile);
    }

    public int hashCode() {
        return this.storageProfile.hashCode();
    }

    private static class StorageProfileDescriptorSerializer
    implements CatalogObjectSerializer<CatalogStorageProfileDescriptor> {
        private StorageProfileDescriptorSerializer() {
        }

        @Override
        public CatalogStorageProfileDescriptor readFrom(IgniteDataInput input) throws IOException {
            String storageProfileDescriptor = input.readUTF();
            return new CatalogStorageProfileDescriptor(storageProfileDescriptor);
        }

        @Override
        public void writeTo(CatalogStorageProfileDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeUTF(descriptor.storageProfile());
        }
    }
}

