/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.loader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.ignite.compute.ComputeException;
import org.apache.ignite.internal.compute.loader.JobClassLoader;
import org.apache.ignite.internal.deployunit.DisposableDeploymentUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.ErrorGroups;

public class JobClassLoaderFactory {
    private static final IgniteLogger LOG = Loggers.forClass(JobClassLoaderFactory.class);

    public JobClassLoader createClassLoader(final List<DisposableDeploymentUnit> units) {
        return AccessController.doPrivileged(new PrivilegedAction<JobClassLoader>(){

            @Override
            public JobClassLoader run() {
                Object[] classpath = (URL[])units.stream().map(DisposableDeploymentUnit::path).flatMap(x$0 -> JobClassLoaderFactory.collectClasspath(x$0)).toArray(URL[]::new);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created class loader with classpath: {}", new Object[]{Arrays.toString(classpath)});
                }
                return new JobClassLoader(units, (URL[])classpath, this.getClass().getClassLoader());
            }
        });
    }

    private static Stream<URL> collectClasspath(Path unitDir) {
        if (Files.notExists(unitDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Unit does not exist: " + String.valueOf(unitDir));
        }
        if (!Files.isDirectory(unitDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Unit is not a directory: " + String.valueOf(unitDir));
        }
        try {
            ClasspathCollector classpathCollector = new ClasspathCollector(unitDir);
            Files.walkFileTree(unitDir, classpathCollector);
            return classpathCollector.classpathAsStream();
        }
        catch (IOException e) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_PATH_ERR, "Failed to construct classpath for job: " + String.valueOf(unitDir), (Throwable)e);
        }
    }

    private static class ClasspathCollector
    extends SimpleFileVisitor<Path> {
        private final List<URL> classpath = new ArrayList<URL>();

        private ClasspathCollector(Path base) throws MalformedURLException {
            this.classpath.add(base.toAbsolutePath().toUri().toURL());
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Files.isDirectory(file, new LinkOption[0]) || file.toString().endsWith(".jar")) {
                this.classpath.add(file.toAbsolutePath().toUri().toURL());
            }
            return FileVisitResult.CONTINUE;
        }

        Stream<URL> classpathAsStream() {
            return this.classpath.stream();
        }
    }
}

